/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import hudson.console.ConsoleNote;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.Messages;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;

public class ConsoleDetail
implements ModelObject {
    private int lineCount;
    private String sourceCode = "";
    private final Run<?, ?> owner;
    private final int from;
    private final int to;
    private final int end;
    private final int start;

    public ConsoleDetail(Run<?, ?> owner, Stream<String> consoleLog, int from, int to) {
        this.owner = owner;
        this.from = from;
        this.to = to;
        this.start = Math.max(1, from - 10);
        this.end = to + 10;
        this.readConsole(consoleLog.skip(this.start - 1).limit(this.end - this.start + 1));
    }

    private void readConsole(Stream<String> consoleLog) {
        StringBuilder console = new StringBuilder(1024);
        console.append("<table>\n");
        this.lineCount = 0;
        consoleLog.forEach(line -> {
            console.append("<tr><td ");
            if (this.lineCount >= this.from - this.start && this.lineCount <= this.to - this.start) {
                console.append("style=\"background-color:#FCAF3E\"");
            }
            console.append(">");
            console.append(StringEscapeUtils.escapeHtml4((String)line));
            console.append("</td></tr>\n");
            ++this.lineCount;
        });
        console.append("</table>\n");
        this.sourceCode = ConsoleNote.removeNotes((String)console.toString());
    }

    public String getDisplayName() {
        return Messages.ConsoleLog_View_Title(this.start, this.end);
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }
}

