/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.charts.CompositeBuildResult;
import io.jenkins.plugins.analysis.core.charts.JenkinsBuild;
import io.jenkins.plugins.analysis.core.charts.ToolsTrendChart;
import io.jenkins.plugins.analysis.core.model.AnalysisHistory;
import io.jenkins.plugins.analysis.core.model.ByIdResultSelector;
import io.jenkins.plugins.analysis.core.model.JobAction;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.ToolNameRegistry;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import io.jenkins.plugins.echarts.AsyncConfigurableTrendChart;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class AggregatedTrendAction
implements Action,
AsyncConfigurableTrendChart {
    private static final int MIN_TOOLS = 2;
    private final Job<?, ?> owner;

    AggregatedTrendAction(Job<?, ?> owner) {
        this.owner = owner;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "warnings-aggregation";
    }

    private Set<AnalysisHistory> createBuildHistory() {
        Run lastFinishedRun = this.owner.getLastCompletedBuild();
        if (lastFinishedRun == null) {
            return new HashSet<AnalysisHistory>();
        }
        return this.owner.getActions(JobAction.class).stream().map(JobAction::getId).map(id -> new AnalysisHistory(lastFinishedRun, new ByIdResultSelector((String)id))).collect(Collectors.toSet());
    }

    @JavaScriptMethod
    public String getConfigurableBuildTrendModel(String configuration) {
        return new JacksonFacade().toJson((Object)this.createChartModel(ChartModelConfiguration.fromJson((String)configuration)));
    }

    private LinesChartModel createChartModel(ChartModelConfiguration configuration) {
        Run lastBuild = this.owner.getLastBuild();
        if (lastBuild == null) {
            return new LinesChartModel();
        }
        ToolNameRegistry nameRegistry = ToolNameRegistry.fromBuild(lastBuild);
        return new ToolsTrendChart(nameRegistry.asMap()).create(new CompositeBuildResultsIterable(lastBuild), configuration);
    }

    public boolean isTrendVisible() {
        Set<AnalysisHistory> history = this.createBuildHistory();
        if (history.size() < 2) {
            return false;
        }
        AnalysisHistory singleResult = history.iterator().next();
        return singleResult.hasMultipleResults();
    }

    private static class CompositeBuildResultsIterable
    implements Iterable<BuildResult<AnalysisBuildResult>> {
        private final Run<?, ?> lastBuild;

        CompositeBuildResultsIterable(Run<?, ?> lastBuild) {
            this.lastBuild = lastBuild;
        }

        @Override
        @NonNull
        public Iterator<BuildResult<AnalysisBuildResult>> iterator() {
            return new CompositeIterator(this.lastBuild);
        }
    }

    private static class CompositeIterator
    implements Iterator<BuildResult<AnalysisBuildResult>> {
        private Optional<Run<?, ?>> latestAction;

        CompositeIterator(Run<?, ?> current) {
            this.latestAction = Optional.of(current);
        }

        @Override
        public boolean hasNext() {
            return this.latestAction.isPresent();
        }

        @Override
        public BuildResult<AnalysisBuildResult> next() {
            if (this.latestAction.isEmpty()) {
                throw new NoSuchElementException("No more build results available");
            }
            Run<?, ?> run = this.latestAction.get();
            this.latestAction = Optional.ofNullable(run.getPreviousBuild());
            Set results = run.getActions(ResultAction.class).stream().map(ResultAction::getResult).collect(Collectors.toSet());
            return new BuildResult((Build)new JenkinsBuild(run), (Object)new CompositeBuildResult(results));
        }
    }
}

