/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.charts;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import io.jenkins.plugins.analysis.core.charts.ToolSeriesBuilder;
import io.jenkins.plugins.analysis.core.charts.TrendChart;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import io.jenkins.plugins.echarts.JenkinsPalette;
import java.util.Collections;
import java.util.Map;

public class ToolsTrendChart
implements TrendChart {
    private final Map<String, String> toolNames;

    public ToolsTrendChart() {
        this(Collections.emptyMap());
    }

    public ToolsTrendChart(Map<String, String> toolNames) {
        this.toolNames = toolNames;
    }

    @Override
    public LinesChartModel create(Iterable<? extends BuildResult<AnalysisBuildResult>> results, ChartModelConfiguration configuration) {
        ToolSeriesBuilder builder = new ToolSeriesBuilder();
        LinesDataSet lineModel = builder.createDataSet(configuration, results);
        LinesChartModel model = new LinesChartModel(lineModel);
        int index = 0;
        for (String toolId : lineModel.getDataSetIds()) {
            String displayName = this.toolNames.getOrDefault(toolId, toolId);
            LineSeries lineSeries = new LineSeries(displayName, JenkinsPalette.chartColor((int)index).normal(), LineSeries.StackedMode.SEPARATE_LINES, LineSeries.FilledMode.LINES);
            lineSeries.addAll(lineModel.getSeries(toolId));
            model.addSeries(new LineSeries[]{lineSeries});
            ++index;
        }
        return model;
    }
}

