/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.Issue;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.util.AffectedFilesResolver;
import io.jenkins.plugins.analysis.core.util.ConsoleLogReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.stream.Stream;

public class BuildFolderFacade
implements Serializable {
    private static final long serialVersionUID = 1904631270145841113L;

    @MustBeClosed
    public Stream<String> readConsoleLog(Run<?, ?> build) {
        return new ConsoleLogReaderFactory(build).readStream();
    }

    @MustBeClosed
    public Reader readFile(Run<?, ?> build, String fileName, Charset sourceEncoding) throws IOException {
        InputStream inputStream = AffectedFilesResolver.asStream(build, fileName);
        return new InputStreamReader(inputStream, sourceEncoding);
    }

    public boolean canAccessAffectedFileOf(Run<?, ?> build, Issue issue) {
        return AffectedFilesResolver.hasAffectedFile(build, issue);
    }
}

