/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.analysis.core.steps.Messages;
import io.jenkins.plugins.analysis.core.steps.WarningChecksPublisher;
import io.jenkins.plugins.analysis.core.util.ModelValidation;
import io.jenkins.plugins.prism.SourceCodeRetention;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.ValidationUtilities;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class AnalysisStepDescriptor
extends StepDescriptor {
    private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();
    private static final JenkinsFacade JENKINS = new JenkinsFacade();
    private final ModelValidation model = new ModelValidation();

    public String getDefaultId() {
        return "analysis";
    }

    public String getDefaultName() {
        return Messages.Tool_Default_Name();
    }

    public String getDefaultIcon() {
        return "symbol-solid/triangle-exclamation plugin-font-awesome-api";
    }

    @POST
    public ComboBoxModel doFillSourceCodeEncodingItems(@AncestorInPath BuildableItem project) {
        if (JENKINS.hasPermission(Item.READ, (AccessControlled)project)) {
            return VALIDATION_UTILITIES.getAllCharsets();
        }
        return new ComboBoxModel();
    }

    @POST
    public FormValidation doCheckReportEncoding(@AncestorInPath BuildableItem project, @QueryParameter String reportEncoding) {
        if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
            return FormValidation.ok();
        }
        return VALIDATION_UTILITIES.validateCharset(reportEncoding);
    }

    @POST
    public FormValidation doCheckSourceCodeEncoding(@AncestorInPath BuildableItem project, @QueryParameter String sourceCodeEncoding) {
        if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
            return FormValidation.ok();
        }
        return VALIDATION_UTILITIES.validateCharset(sourceCodeEncoding);
    }

    @POST
    public ListBoxModel doFillSourceCodeRetentionItems() {
        if (JENKINS.hasPermission(Jenkins.READ)) {
            return SourceCodeRetention.fillItems();
        }
        return new ListBoxModel();
    }

    @POST
    public ListBoxModel doFillMinimumSeverityItems() {
        if (JENKINS.hasPermission(Jenkins.READ)) {
            return this.model.getAllSeverityFilters();
        }
        return new ListBoxModel();
    }

    @POST
    public FormValidation doCheckHealthy(@AncestorInPath BuildableItem project, @QueryParameter int healthy, @QueryParameter int unhealthy) {
        if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
            return FormValidation.ok();
        }
        return this.model.validateHealthy(healthy, unhealthy);
    }

    @POST
    public FormValidation doCheckUnhealthy(@AncestorInPath BuildableItem project, @QueryParameter int healthy, @QueryParameter int unhealthy) {
        if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
            return FormValidation.ok();
        }
        return this.model.validateUnhealthy(healthy, unhealthy);
    }

    @POST
    public ListBoxModel doFillTrendChartTypeItems() {
        if (JENKINS.hasPermission(Jenkins.READ)) {
            return this.model.getAllTrendChartTypes();
        }
        return new ListBoxModel();
    }

    @POST
    public FormValidation doCheckId(@AncestorInPath BuildableItem project, @QueryParameter String id) {
        if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
            return FormValidation.ok();
        }
        return VALIDATION_UTILITIES.validateId(id);
    }

    @POST
    public ListBoxModel doFillChecksAnnotationScopeItems() {
        if (JENKINS.hasPermission(Jenkins.READ)) {
            return WarningChecksPublisher.ChecksAnnotationScope.fillItems();
        }
        return new ListBoxModel();
    }

    public String argumentsToString(@NonNull Map<String, Object> namedArgs) {
        String formatted = super.argumentsToString(namedArgs);
        if (formatted != null) {
            return formatted;
        }
        return namedArgs.toString();
    }
}

