/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.portlets;

import edu.hm.hafner.util.Generated;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.view.dashboard.DashboardPortlet;
import io.jenkins.plugins.analysis.core.model.LabelProviderFactory;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.model.ToolSelection;
import io.jenkins.plugins.analysis.core.portlets.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class IssuesTablePortlet
extends DashboardPortlet {
    private boolean hideCleanJobs;
    private boolean showIcons;
    private boolean selectTools;
    private List<ToolSelection> tools = new ArrayList<ToolSelection>();
    private LabelProviderFactory labelProviderFactory = new LabelProviderFactory();

    @DataBoundConstructor
    public IssuesTablePortlet(String name) {
        super(name);
    }

    @VisibleForTesting
    void setLabelProviderFactory(LabelProviderFactory labelProviderFactory) {
        this.labelProviderFactory = labelProviderFactory;
    }

    public boolean getHideCleanJobs() {
        return this.hideCleanJobs;
    }

    @DataBoundSetter
    public void setHideCleanJobs(boolean hideCleanJobs) {
        this.hideCleanJobs = hideCleanJobs;
    }

    public boolean getShowIcons() {
        return this.showIcons;
    }

    @DataBoundSetter
    public void setShowIcons(boolean showIcons) {
        this.showIcons = showIcons;
    }

    public boolean getSelectTools() {
        return this.selectTools;
    }

    @DataBoundSetter
    public void setSelectTools(boolean selectTools) {
        this.selectTools = selectTools;
    }

    public List<ToolSelection> getTools() {
        return this.tools;
    }

    @DataBoundSetter
    public void setTools(List<ToolSelection> tools) {
        this.tools = new ArrayList<ToolSelection>(tools);
    }

    private List<Job<?, ?>> getVisibleJobs(List<Job<?, ?>> jobs) {
        return this.hideCleanJobs ? this.removeZeroIssuesJobs(jobs) : jobs;
    }

    private List<Job<?, ?>> removeZeroIssuesJobs(List<Job<?, ?>> jobs) {
        return jobs.stream().filter(this::isVisible).collect(Collectors.toList());
    }

    private boolean isVisible(Job<?, ?> job) {
        Run lastCompletedBuild = job.getLastCompletedBuild();
        if (lastCompletedBuild == null) {
            return true;
        }
        return lastCompletedBuild.getActions(ResultAction.class).stream().filter(ToolSelection.createToolFilter(this.selectTools, this.tools)).anyMatch(resultAction -> resultAction.getResult().getTotalSize() > 0);
    }

    public PortletTableModel getModel(List<Job<?, ?>> jobs) {
        return new PortletTableModel(this.getVisibleJobs(jobs), ToolSelection.createToolFilter(this.selectTools, this.tools), this.labelProviderFactory);
    }

    public static class PortletTableModel {
        private final List<TableRow> rows = new ArrayList<TableRow>();
        private final SortedSet<Column> columns;

        PortletTableModel(List<Job<?, ?>> visibleJobs, Predicate<ResultAction> filter, LabelProviderFactory labelProviderFactory) {
            this.columns = visibleJobs.stream().filter(job -> job.getLastCompletedBuild() != null).map(Job::getLastCompletedBuild).flatMap(build -> build.getActions(ResultAction.class).stream().filter(filter)).collect(Collectors.toList()).stream().map(r -> this.createColumn((ResultAction)r, labelProviderFactory)).collect(Collectors.toCollection(TreeSet::new));
            this.populateRows(visibleJobs);
        }

        public SortedSet<Column> getColumns() {
            return this.columns;
        }

        private Column createColumn(ResultAction result, LabelProviderFactory labelProviderFactory) {
            StaticAnalysisLabelProvider labelProvider = labelProviderFactory.create(result.getId(), result.getName());
            return new Column(result.getId(), labelProvider.getName(), labelProvider.getLinkName(), labelProvider.getSmallIconUrl());
        }

        private void populateRows(List<Job<?, ?>> visibleJobs) {
            for (Job<?, ?> job : visibleJobs) {
                TableRow row = new TableRow(job);
                for (Column column : this.columns) {
                    Run lastCompletedBuild = job.getLastCompletedBuild();
                    if (lastCompletedBuild == null) {
                        row.add(Result.EMPTY);
                        continue;
                    }
                    Result result = lastCompletedBuild.getActions(ResultAction.class).stream().filter(action -> action.getId().equals(column.getId())).findFirst().map(Result::new).orElse(Result.EMPTY);
                    row.add(result);
                }
                this.rows.add(row);
            }
        }

        public int size() {
            return this.rows.size();
        }

        public List<TableRow> getRows() {
            return this.rows;
        }
    }

    @Extension(optional=true)
    public static class IssuesTablePortletDescriptor
    extends Descriptor<DashboardPortlet> {
        @NonNull
        public String getDisplayName() {
            return Messages.IssuesTablePortlet_Name();
        }
    }

    public static class Result {
        static final Result EMPTY = new Result("");
        private int size;
        private final String url;

        private Result(String urlName) {
            this.url = urlName;
        }

        Result(ResultAction action) {
            this(action.getRelativeUrl());
            this.size = action.getResult().getTotalSize();
        }

        public OptionalInt getTotal() {
            if (StringUtils.isEmpty((CharSequence)this.url)) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(this.size);
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class TableRow {
        private final Job<?, ?> job;
        private final List<Result> results = new ArrayList<Result>();

        TableRow(Job<?, ?> job) {
            this.job = job;
        }

        public Job<?, ?> getJob() {
            return this.job;
        }

        public List<Result> getResults() {
            return this.results;
        }

        void add(Result result) {
            this.results.add(result);
        }
    }

    public static final class Column
    implements Comparable<Column> {
        private final String id;
        private final String name;
        private final String linkName;
        private final String icon;

        Column(String id, String name, String linkName, String icon) {
            this.id = id;
            this.name = name;
            this.linkName = linkName;
            this.icon = icon;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getLinkName() {
            return this.linkName;
        }

        public String getIcon() {
            return this.icon;
        }

        @Override
        public int compareTo(Column o) {
            return this.id.compareTo(o.getId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            return Objects.equals(this.id, column.id) && Objects.equals(this.name, column.name) && Objects.equals(this.linkName, column.linkName) && Objects.equals(this.icon, column.icon);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.linkName, this.icon);
        }

        @Generated
        public String toString() {
            return "Column{id='" + this.id + "', name='" + this.name + "', linkName='" + this.linkName + "', icon='" + this.icon + "'}";
        }
    }
}

