/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import com.google.errorprone.annotations.CheckReturnValue;
import edu.hm.hafner.analysis.Severity;
import hudson.model.HealthReport;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.util.HealthDescriptor;
import java.util.Map;

public class HealthReportBuilder {
    @CheckReturnValue
    HealthReport computeHealth(HealthDescriptor healthDescriptor, StaticAnalysisLabelProvider labelProvider, Map<Severity, Integer> sizePerSeverity) {
        int relevantIssuesSize = 0;
        for (Severity severity : Severity.collectSeveritiesFrom((Severity)healthDescriptor.getMinimumSeverity())) {
            relevantIssuesSize += sizePerSeverity.getOrDefault(severity, 0).intValue();
        }
        if (healthDescriptor.isValid()) {
            int unhealthy;
            int healthy = healthDescriptor.getHealthy();
            int percentage = healthy == 0 ? (relevantIssuesSize == 0 ? 100 : 0) : (relevantIssuesSize < healthy ? 100 : (relevantIssuesSize > (unhealthy = healthDescriptor.getUnhealthy()) ? 0 : 100 - (relevantIssuesSize - healthy + 1) * 100 / (unhealthy - healthy + 2)));
            return new HealthReport(percentage, labelProvider.getToolTipLocalizable(relevantIssuesSize));
        }
        return null;
    }
}

