/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.IssuesDetail;
import io.jenkins.plugins.analysis.core.model.Messages;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.util.AffectedFilesResolver;
import io.jenkins.plugins.analysis.core.util.ConsoleLogHandler;
import java.nio.charset.Charset;
import java.util.Optional;

public class FixedWarningsDetail
extends IssuesDetail {
    private static final Report NO_ISSUES = new Report();

    FixedWarningsDetail(Run<?, ?> owner, AnalysisResult result, Report fixedIssues, String url, StaticAnalysisLabelProvider labelProvider, Charset sourceEncoding) {
        super(owner, result, fixedIssues, NO_ISSUES, NO_ISSUES, fixedIssues, Messages.Fixed_Warnings_Header(), url, labelProvider, sourceEncoding);
    }

    @Override
    public boolean canDisplayFile(Issue issue) {
        Optional<Run<?, ?>> referenceBuild = this.getResult().getReferenceBuild();
        return referenceBuild.filter(run -> ConsoleLogHandler.isInConsoleLog(issue.getFileName()) || AffectedFilesResolver.hasAffectedFile(run, issue)).isPresent();
    }

    public String getReferenceUrl() {
        return this.getResult().getReferenceBuild().map(Run::getUrl).map(url -> url + this.getResult().getId()).orElse("");
    }
}

