/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.Messages;
import io.jenkins.plugins.analysis.core.util.BuildFolderFacade;
import io.jenkins.plugins.analysis.core.util.ConsoleLogHandler;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;

public class FileNameRenderer {
    private final BuildFolderFacade facade;
    private final Run<?, ?> build;

    public FileNameRenderer(Run<?, ?> build) {
        this(build, new BuildFolderFacade());
    }

    @VisibleForTesting
    public FileNameRenderer(Run<?, ?> build, BuildFolderFacade facade) {
        this.facade = facade;
        this.build = build;
    }

    public String renderAffectedFileLink(Issue issue) {
        return this.createAffectedFileLink(issue).render();
    }

    public DomContent createAffectedFileLink(Issue issue) {
        return this.createAffectedFileLink(issue, "");
    }

    public DomContent createAffectedFileLink(Issue issue, String prefix) {
        if (ConsoleLogHandler.isInConsoleLog(issue.getFileName())) {
            return ((ContainerTag)TagCreator.a().withHref(prefix + this.getSourceCodeUrl(issue))).withText(this.getFileNameAtLine(issue));
        }
        if (this.facade.canAccessAffectedFileOf(this.build, issue)) {
            return ((ContainerTag)((ContainerTag)((ContainerTag)TagCreator.a().withHref(prefix + this.getSourceCodeUrl(issue))).withText(this.getFileNameAtLine(issue)).attr("data-bs-toggle", (Object)"tooltip")).attr("data-bs-placement", (Object)"top")).withTitle(issue.getFileName());
        }
        return TagCreator.text((String)this.getFileNameAtLine(issue));
    }

    public String getSourceCodeUrl(Issue issue) {
        return "source.%s/#%d".formatted(issue.getId(), issue.getLineStart());
    }

    public String getFileNameAtLine(Issue issue) {
        return "%s:%d".formatted(this.getFileName(issue), issue.getLineStart());
    }

    public String getFileName(Issue issue) {
        if (ConsoleLogHandler.isInConsoleLog(issue.getFileName())) {
            return Messages.ConsoleLog_Name();
        }
        return issue.getBaseName();
    }
}

