/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.util.IntegerParser;
import io.jenkins.plugins.analysis.core.model.DescriptionProvider;
import io.jenkins.plugins.analysis.core.model.FileNameRenderer;
import io.jenkins.plugins.analysis.core.model.Messages;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.util.LocalizedSeverity;
import io.jenkins.plugins.datatables.DetailedCell;
import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.datatables.TableConfiguration;
import io.jenkins.plugins.datatables.TableModel;
import io.jenkins.plugins.prism.Sanitizer;
import io.jenkins.plugins.util.JenkinsFacade;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.DomContentJoiner;
import j2html.tags.UnescapedText;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public abstract class DetailsTableModel
extends TableModel {
    private final StaticAnalysisLabelProvider.AgeBuilder ageBuilder;
    private final FileNameRenderer fileNameRenderer;
    private final DescriptionProvider descriptionProvider;
    private final JenkinsFacade jenkinsFacade;
    private final Report report;

    protected DetailsTableModel(Report report, FileNameRenderer fileNameRenderer, StaticAnalysisLabelProvider.AgeBuilder ageBuilder, DescriptionProvider descriptionProvider, JenkinsFacade jenkinsFacade) {
        this.report = report;
        this.fileNameRenderer = fileNameRenderer;
        this.ageBuilder = ageBuilder;
        this.descriptionProvider = descriptionProvider;
        this.jenkinsFacade = jenkinsFacade;
    }

    public TableConfiguration getTableConfiguration() {
        TableConfiguration tableConfiguration = new TableConfiguration();
        tableConfiguration.responsive();
        return tableConfiguration;
    }

    protected JenkinsFacade getJenkinsFacade() {
        return this.jenkinsFacade;
    }

    protected Report getReport() {
        return this.report;
    }

    protected FileNameRenderer getFileNameRenderer() {
        return this.fileNameRenderer;
    }

    protected StaticAnalysisLabelProvider.AgeBuilder getAgeBuilder() {
        return this.ageBuilder;
    }

    protected DescriptionProvider getDescriptionProvider() {
        return this.descriptionProvider;
    }

    public List<Object> getRows() {
        ArrayList<Object> rows = new ArrayList<Object>();
        for (Issue issue : this.report) {
            rows.add(this.getRow(issue));
        }
        return rows;
    }

    protected TableColumn createDetailsColumn() {
        return new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_Details()).withDataPropertyKey("description").withResponsivePriority(1).withHeaderClass(TableColumn.ColumnCss.NO_SORT).build();
    }

    protected TableColumn createHiddenDetailsColumn() {
        return new TableColumn.ColumnBuilder().withHeaderLabel("Hiddendetails").withDataPropertyKey("message").withHeaderClass(TableColumn.ColumnCss.HIDDEN).build();
    }

    protected TableColumn createFileColumn() {
        return new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_File()).withDataPropertyKey("fileName").withResponsivePriority(1).withDetailedCell().build();
    }

    protected TableColumn createAgeColumn() {
        return new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_Age()).withDataPropertyKey("age").withType(TableColumn.ColumnType.HTML_NUMBER).withResponsivePriority(10).build();
    }

    protected TableColumn createSeverityColumn() {
        return new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_Severity()).withDataPropertyKey("severity").withResponsivePriority(5).build();
    }

    protected TableColumn createPackageColumn() {
        return new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_Package()).withDataPropertyKey("packageName").withResponsivePriority(50000).build();
    }

    protected abstract TableRow getRow(Issue var1);

    public static class TableRow {
        private static final Sanitizer SANITIZER = new Sanitizer();
        private final String description;
        private final String message;
        private final DetailedCell<String> fileName;
        private final String age;
        private final JenkinsFacade jenkinsFacade;

        protected TableRow(StaticAnalysisLabelProvider.AgeBuilder ageBuilder, FileNameRenderer fileNameRenderer, DescriptionProvider descriptionProvider, Issue issue, JenkinsFacade jenkinsFacade) {
            this.jenkinsFacade = jenkinsFacade;
            this.message = StringEscapeUtils.escapeHtml4((String)issue.getMessage());
            this.description = this.formatDetails(issue, descriptionProvider.getDescription(issue));
            this.age = (String)ageBuilder.apply(IntegerParser.parseInt((String)issue.getReference()));
            this.fileName = this.createFileName(fileNameRenderer, issue);
        }

        private DetailedCell<String> createFileName(FileNameRenderer fileNameRenderer, Issue issue) {
            return new DetailedCell(fileNameRenderer.renderAffectedFileLink(issue), (Object)"%s:%07d".formatted(issue.getFileName(), issue.getLineStart()));
        }

        private String formatDetails(Issue issue, String additionalDescription) {
            UnescapedText details = StringUtils.isBlank((CharSequence)issue.getMessage()) ? new UnescapedText(this.render(additionalDescription)) : DomContentJoiner.join((CharSequence)" ", (boolean)false, (Object[])new Object[]{TagCreator.p((DomContent[])new DomContent[]{TagCreator.strong().with((DomContent)new UnescapedText(StringEscapeUtils.escapeHtml4((String)issue.getMessage())))}), this.render(additionalDescription)});
            return TableColumn.renderDetailsColumn((String)details.render(), (JenkinsFacade)this.jenkinsFacade);
        }

        protected final String formatSeverity(Severity severity) {
            return "<a href=\"%s\">%s</a>".formatted(severity.getName(), LocalizedSeverity.getLocalizedString(severity));
        }

        protected final String formatProperty(String property, String value) {
            String renderedValue = this.render(value);
            if (StringUtils.isBlank((CharSequence)value)) {
                renderedValue = "-";
            }
            return "<a href=\"%s.%d/\">%s</a>".formatted(property, value.hashCode(), renderedValue);
        }

        protected final String render(UnescapedText text) {
            return SANITIZER.render((DomContent)text);
        }

        protected final String render(String html) {
            return SANITIZER.render(html);
        }

        public String getDescription() {
            return this.description;
        }

        public String getMessage() {
            return this.message;
        }

        public DetailedCell<String> getFileName() {
            return this.fileName;
        }

        public String getAge() {
            return this.age;
        }
    }
}

