/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.groovy;

import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.util.Ensure;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.analysis.core.model.ReportScanningTool;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.warnings.Messages;
import io.jenkins.plugins.analysis.warnings.groovy.GroovyParser;
import io.jenkins.plugins.analysis.warnings.groovy.ParserConfiguration;
import io.jenkins.plugins.util.JenkinsFacade;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.verb.POST;

public class GroovyScript
extends ReportScanningTool {
    private static final long serialVersionUID = 8580859196688994603L;
    private static final String ID = "groovy";
    private final String parserId;

    @DataBoundConstructor
    public GroovyScript(String parserId) {
        Ensure.that((boolean)ParserConfiguration.getInstance().contains(parserId)).isTrue("There is no Groovy parser defined in the system configuration with ID '%s'", new Object[]{parserId});
        this.parserId = parserId;
    }

    public String getParserId() {
        return this.parserId;
    }

    @Override
    public IssueParser createParser() {
        return this.getTool().createParser();
    }

    @Override
    public StaticAnalysisLabelProvider getLabelProvider() {
        return new StaticAnalysisLabelProvider(this.parserId, this.getTool().getName());
    }

    private GroovyParser getTool() {
        return ParserConfiguration.getInstance().getParser(this.parserId);
    }

    @Override
    public String getActualId() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getId(), (CharSequence)this.parserId);
    }

    @Override
    public String getActualName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getName(), (CharSequence)this.getTool().getName());
    }

    @Symbol(value={"groovyScript"})
    @Extension
    public static class Descriptor
    extends ReportScanningTool.ReportScanningToolDescriptor {
        public Descriptor() {
            super(GroovyScript.ID);
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Warnings_Groovy_DescribableName();
        }

        @Override
        public boolean canScanConsoleLog() {
            return ParserConfiguration.getInstance().isConsoleLogScanningPermitted();
        }

        @POST
        public ListBoxModel doFillParserIdItems(@AncestorInPath BuildableItem project) {
            if (new JenkinsFacade().hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                ListBoxModel options = ParserConfiguration.getInstance().asListBoxModel();
                if (options.isEmpty()) {
                    return options.add(Messages.Warnings_Groovy_NoParsersDefined());
                }
                return options;
            }
            return new ListBoxModel();
        }
    }
}

