/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.groovy;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.Serializable;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.codehaus.groovy.control.CompilationFailedException;

class GroovyExpressionMatcher
implements Serializable {
    private static final long serialVersionUID = -2218299240520838315L;
    private static final Logger LOGGER = Logger.getLogger(GroovyExpressionMatcher.class.getName());
    private final String script;
    private transient Script compiled;

    GroovyExpressionMatcher(String script) {
        this.script = script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileScriptIfNotYetDone() {
        String string = this.script;
        synchronized (string) {
            if (this.compiled == null) {
                try {
                    this.compiled = this.compile();
                }
                catch (CompilationFailedException exception) {
                    LOGGER.log(Level.SEVERE, "Groovy dynamic warnings parser: exception during compiling: ", exception);
                    return false;
                }
            }
        }
        return true;
    }

    @SuppressFBWarnings(value={"GROOVY_SHELL"})
    public Script compile() throws CompilationFailedException {
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(GroovyExpressionMatcher.class.getClassLoader(), binding);
        return shell.parse(this.script);
    }

    public Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder, int lineNumber, String fileName) {
        Object wrappedIssue;
        Optional optional;
        Object result = this.run(matcher, builder, lineNumber, fileName);
        if (result instanceof Optional && (optional = (Optional)result).isPresent() && (wrappedIssue = optional.get()) instanceof Issue) {
            Issue issue = (Issue)wrappedIssue;
            return Optional.of(issue);
        }
        return Optional.empty();
    }

    public Object run(Matcher matcher, IssueBuilder builder, int lineNumber, String fileName) {
        if (this.compileScriptIfNotYetDone()) {
            builder.setFileName(fileName);
            builder.setLineStart(lineNumber);
            Binding binding = this.compiled.getBinding();
            binding.setVariable("matcher", (Object)matcher);
            binding.setVariable("builder", (Object)builder);
            binding.setVariable("lineNumber", (Object)lineNumber);
            binding.setVariable("fileName", (Object)fileName);
            return this.runScript();
        }
        return Optional.empty();
    }

    private Object runScript() {
        try {
            return this.compiled.run();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Groovy dynamic warnings parser: exception during execution: ", exception);
            return Optional.empty();
        }
    }
}

