/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.axivion;

import com.google.gson.JsonObject;
import io.jenkins.plugins.analysis.warnings.axivion.AxIssueKind;

final class AxRawIssue {
    private final String dashboardUrl;
    private final String projectDir;
    private final JsonObject payload;
    private final AxIssueKind kind;

    AxRawIssue(String dashboardUrl, String baseDir, JsonObject payload, AxIssueKind kind) {
        this.dashboardUrl = dashboardUrl;
        this.projectDir = baseDir;
        this.payload = payload;
        this.kind = kind;
    }

    String getDashboardUrl() {
        return this.dashboardUrl;
    }

    String getProjectDir() {
        return this.projectDir;
    }

    JsonObject getPayload() {
        return this.payload;
    }

    AxIssueKind getKind() {
        return this.kind;
    }

    String getKindName() {
        return this.getKind().name();
    }

    private boolean isSuppressed() {
        return this.payload.has("suppressed") && this.payload.get("suppressed").getAsBoolean();
    }

    private boolean isJustified() {
        return this.payload.has("justification") && !this.payload.get("justification").getAsString().isEmpty();
    }

    boolean isSuppressedOrJustified() {
        return this.isSuppressed() || this.isJustified();
    }
}

