/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import io.jenkins.plugins.analysis.core.util.IssuesStatistics;
import io.jenkins.plugins.analysis.core.util.WarningsQualityGate;
import io.jenkins.plugins.util.QualityGate;
import io.jenkins.plugins.util.QualityGateEvaluator;
import io.jenkins.plugins.util.QualityGateResult;
import io.jenkins.plugins.util.QualityGateStatus;
import java.util.Collection;

public class WarningsQualityGateEvaluator
extends QualityGateEvaluator<WarningsQualityGate> {
    private final IssuesStatistics statistics;

    public WarningsQualityGateEvaluator(Collection<? extends WarningsQualityGate> qualityGates, IssuesStatistics statistics) {
        super(qualityGates);
        this.statistics = statistics;
    }

    protected void evaluate(WarningsQualityGate qualityGate, QualityGateResult result) {
        if (qualityGate.getThreshold() > 0.0) {
            int actualSize = qualityGate.getActualSizeMethodReference().apply(this.statistics);
            String actualValue = String.valueOf(actualSize);
            if ((double)actualSize >= qualityGate.getThreshold()) {
                result.add((QualityGate)qualityGate, qualityGate.getStatus(), actualValue);
            } else {
                result.add((QualityGate)qualityGate, QualityGateStatus.PASSED, actualValue);
            }
        } else {
            result.add((QualityGate)qualityGate, QualityGateStatus.INACTIVE, "Threshold too small: " + qualityGate.getThreshold());
        }
    }
}

