/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.analysis.core.util.Messages;
import io.jenkins.plugins.analysis.core.util.TrendChartType;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ModelValidation {
    private static final Pattern VALID_ID_PATTERN = Pattern.compile("\\p{Alnum}[\\p{Alnum}-_.]*");
    @VisibleForTesting
    static final String NO_REFERENCE_JOB = "-";
    private final JenkinsFacade jenkins;

    public ModelValidation() {
        this(new JenkinsFacade());
    }

    @VisibleForTesting
    ModelValidation(JenkinsFacade jenkins) {
        this.jenkins = jenkins;
    }

    static String createInvalidIdMessage(String id) {
        return Messages.FieldValidator_Error_WrongIdFormat(VALID_ID_PATTERN.pattern(), id);
    }

    public ListBoxModel getAllSeverityFilters() {
        ListBoxModel options = new ListBoxModel();
        options.add(Messages.SeverityFilter_Error(), Severity.ERROR.getName());
        options.add(Messages.SeverityFilter_High(), Severity.WARNING_HIGH.getName());
        options.add(Messages.SeverityFilter_Normal(), Severity.WARNING_NORMAL.getName());
        options.add(Messages.SeverityFilter_Low(), Severity.WARNING_LOW.getName());
        return options;
    }

    public ListBoxModel getAllTrendChartTypes() {
        ListBoxModel options = new ListBoxModel();
        options.add(Messages.AggregationChart_AGGREGATION_TOOLS(), TrendChartType.AGGREGATION_TOOLS.name());
        options.add(Messages.AggregationChart_TOOLS_AGGREGATION(), TrendChartType.TOOLS_AGGREGATION.name());
        options.add(Messages.AggregationChart_TOOLS_ONLY(), TrendChartType.TOOLS_ONLY.name());
        options.add(Messages.AggregationChart_AGGREGATION_ONLY(), TrendChartType.AGGREGATION_ONLY.name());
        options.add(Messages.AggregationChart_NONE(), TrendChartType.NONE.name());
        return options;
    }

    public ComboBoxModel getAllJobs() {
        ComboBoxModel model = new ComboBoxModel((Collection)this.jenkins.getAllJobNames());
        model.add(0, (Object)NO_REFERENCE_JOB);
        return model;
    }

    public FormValidation validateJob(String referenceJobName) {
        if (NO_REFERENCE_JOB.equals(referenceJobName) || StringUtils.isBlank((CharSequence)referenceJobName) || this.jenkins.getJob(referenceJobName).isPresent()) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.FieldValidator_Error_ReferenceJobDoesNotExist());
    }

    public FormValidation validateThreshold(int threshold) {
        if (threshold > 0) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.FieldValidator_Error_NegativeThreshold());
    }

    public FormValidation validateHealthy(int healthy, int unhealthy) {
        if (healthy >= 0 && unhealthy <= 0) {
            return FormValidation.ok();
        }
        if (healthy == 0 && unhealthy > 0) {
            return FormValidation.ok();
        }
        return this.validateHealthReportConstraints(healthy, healthy, unhealthy);
    }

    public FormValidation validateUnhealthy(int healthy, int unhealthy) {
        if (healthy < 0 && unhealthy == 0) {
            return FormValidation.ok();
        }
        if (healthy > 0 && unhealthy == 0) {
            return FormValidation.error((String)Messages.FieldValidator_Error_ThresholdUnhealthyMissing());
        }
        if (healthy == 0 && unhealthy > 0) {
            return FormValidation.ok();
        }
        return this.validateHealthReportConstraints(unhealthy, healthy, unhealthy);
    }

    private FormValidation validateHealthReportConstraints(int positive, int healthy, int unhealthy) {
        if (healthy == 0 && unhealthy == 0) {
            return FormValidation.ok();
        }
        if (positive <= 0) {
            return FormValidation.error((String)Messages.FieldValidator_Error_NegativeThreshold());
        }
        if (healthy >= unhealthy) {
            if (unhealthy <= 0) {
                return FormValidation.error((String)Messages.FieldValidator_Error_NegativeThreshold());
            }
            return FormValidation.error((String)Messages.FieldValidator_Error_ThresholdOrder());
        }
        return FormValidation.ok();
    }
}

