/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.util;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.FilePath;
import hudson.model.Run;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.prism.FilePermissionEnforcer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class AffectedFilesResolver {
    public static final String AFFECTED_FILES_FOLDER_NAME = "files-with-issues";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String TEXT_EXTENSION = ".tmp";

    public static boolean hasAffectedFile(Run<?, ?> run, Issue issue) {
        return AffectedFilesResolver.canAccess(AffectedFilesResolver.getFile(run, issue.getFileName())) || AffectedFilesResolver.canAccess(AffectedFilesResolver.getZipFile(run, issue.getFileName()));
    }

    private static boolean canAccess(Path file) {
        return Files.isReadable(file);
    }

    static InputStream asStream(Run<?, ?> build, String fileName) throws IOException {
        try {
            Path file = AffectedFilesResolver.getFile(build, fileName);
            if (AffectedFilesResolver.canAccess(file)) {
                return Files.newInputStream(file, new OpenOption[0]);
            }
            return AffectedFilesResolver.extractFromZip(build, fileName);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream extractFromZip(Run<?, ?> build, String fileName) throws IOException, InterruptedException {
        Path tempDir = Files.createTempDirectory(AFFECTED_FILES_FOLDER_NAME, new FileAttribute[0]);
        FilePath unzippedSourcesDir = new FilePath(tempDir.toFile());
        try {
            Path zipFile = AffectedFilesResolver.getZipFile(build, fileName);
            FilePath inputZipFile = new FilePath(zipFile.toFile());
            inputZipFile.unzip(unzippedSourcesDir);
            StringUtils.removeEnd((String)zipFile.toString(), (String)ZIP_EXTENSION);
            Path sourceFile = tempDir.resolve(FilenameUtils.getName((String)fileName));
            InputStream inputStream = Files.newInputStream(sourceFile, new OpenOption[0]);
            return inputStream;
        }
        finally {
            try {
                unzippedSourcesDir.deleteRecursive();
            }
            catch (IOException | InterruptedException exception) {}
        }
    }

    public static Path getFile(Run<?, ?> run, String fileName) {
        return AffectedFilesResolver.getPath(run, AffectedFilesResolver.getTempName(fileName));
    }

    public static Path getZipFile(Run<?, ?> run, String fileName) {
        return AffectedFilesResolver.getPath(run, AffectedFilesResolver.getZipName(fileName));
    }

    private static Path getPath(Run<?, ?> run, String zipName) {
        return run.getRootDir().toPath().resolve(AFFECTED_FILES_FOLDER_NAME).resolve(zipName);
    }

    private static String getTempName(String fileName) {
        return Integer.toHexString(fileName.hashCode()) + TEXT_EXTENSION;
    }

    private static String getZipName(String fileName) {
        return AffectedFilesResolver.getTempName(fileName) + ZIP_EXTENSION;
    }

    private static String getBatchZipFileName(String reportId) {
        return "batch-" + reportId + ZIP_EXTENSION;
    }

    public void copyAffectedFilesToBuildFolder(Report report, FilePath workspace, Set<String> permittedSourceDirectories, FilePath buildFolder) throws InterruptedException {
        this.copyAffectedFilesToBuildFolder(report, new RemoteFacade(workspace, permittedSourceDirectories, buildFolder));
    }

    @VisibleForTesting
    void copyAffectedFilesToBuildFolder(Report report, RemoteFacade remoteFacade) throws InterruptedException {
        FilteredLog log = new FilteredLog("Can't copy some affected workspace files to Jenkins build folder:");
        try {
            CopyResult result = remoteFacade.copyAllInBatch(report, log);
            log.getInfoMessages().forEach(x$0 -> report.logInfo(x$0, new Object[0]));
            log.getErrorMessages().forEach(x$0 -> report.logError(x$0, new Object[0]));
            report.logInfo("-> %d copied, %d not in workspace, %d not-found, %d with I/O error", new Object[]{result.getCopied(), result.getNotInWorkspace(), result.getNotFound(), log.size()});
        }
        catch (IOException exception) {
            report.logError("Failed to copy files in batch: %s", new Object[]{exception.getMessage()});
            report.logInfo("-> 0 copied, 0 not in workspace, 0 not-found, 0 with I/O error", new Object[0]);
        }
    }

    static class RemoteFacade {
        private static final PathUtil PATH_UTIL = new PathUtil();
        private static final FilePermissionEnforcer PERMISSION_ENFORCER = new FilePermissionEnforcer();
        private final FilePath buildFolder;
        private final FilePath workspace;
        private final Set<String> permittedAbsolutePaths;

        RemoteFacade(FilePath workspace, Set<String> permittedSourceDirectories, FilePath buildFolder) {
            this.workspace = workspace;
            this.permittedAbsolutePaths = permittedSourceDirectories.stream().map(arg_0 -> ((PathUtil)PATH_UTIL).getAbsolutePath(arg_0)).collect(Collectors.toSet());
            this.buildFolder = buildFolder;
        }

        boolean exists(String fileName) {
            try {
                return this.createFile(fileName).exists();
            }
            catch (IOException | InterruptedException exception) {
                return false;
            }
        }

        private FilePath createFile(String fileName) {
            return new FilePath(this.workspace.getChannel(), fileName);
        }

        boolean isInWorkspace(String fileName) {
            String sourceFile = PATH_UTIL.getAbsolutePath(this.createFile(fileName).getRemote());
            return PERMISSION_ENFORCER.isInWorkspace(sourceFile, this.workspace, this.permittedAbsolutePaths);
        }

        public void copy(String from, String to) throws IOException, InterruptedException {
            FilePath file = this.createFile(from);
            if (!file.toVirtualFile().canRead()) {
                throw new IOException("Can't read file: " + from);
            }
            file.zip(this.computeBuildFolderFileName(to));
        }

        public boolean existsInBuildFolder(String fileName) {
            try {
                return this.computeBuildFolderFileName(fileName).exists();
            }
            catch (IOException | InterruptedException ignore) {
                return false;
            }
        }

        private FilePath computeBuildFolderFileName(String fileName) {
            return this.buildFolder.child(AffectedFilesResolver.getZipName(fileName));
        }

        CopyResult copyAllInBatch(Report report, FilteredLog log) throws IOException, InterruptedException {
            this.buildFolder.mkdirs();
            Set<String> filesToSkip = this.getFilesToSkip(report);
            CopyResult copyResult = (CopyResult)this.workspace.act((FilePath.FileCallable)new BatchFileCopier(report, this.permittedAbsolutePaths, log, filesToSkip));
            if (copyResult.getCopied() > 0) {
                this.transferBatchZipToController(report.getId());
            }
            return copyResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transferBatchZipToController(String reportId) throws IOException, InterruptedException {
            String batchZipFileName = AffectedFilesResolver.getBatchZipFileName(reportId);
            FilePath batchZipOnAgent = this.workspace.child(batchZipFileName);
            FilePath batchZipOnController = this.buildFolder.child(batchZipFileName);
            try {
                batchZipOnAgent.copyTo(batchZipOnController);
                batchZipOnController.unzip(this.buildFolder);
            }
            finally {
                try {
                    batchZipOnController.delete();
                }
                finally {
                    batchZipOnAgent.delete();
                }
            }
        }

        private Set<String> getFilesToSkip(Report report) {
            return ((Stream)report.stream().parallel()).map(Issue::getFileName).filter(this::fileExistsInBuildFolder).collect(Collectors.toSet());
        }

        private boolean fileExistsInBuildFolder(String fileName) {
            try {
                return this.buildFolder.child(AffectedFilesResolver.getZipName(fileName)).exists();
            }
            catch (IOException | InterruptedException ignore) {
                return false;
            }
        }
    }

    static class CopyResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int copied;
        private final int notFound;
        private final int notInWorkspace;

        CopyResult(int copied, int notFound, int notInWorkspace) {
            this.copied = copied;
            this.notFound = notFound;
            this.notInWorkspace = notInWorkspace;
        }

        int getCopied() {
            return this.copied;
        }

        int getNotFound() {
            return this.notFound;
        }

        int getNotInWorkspace() {
            return this.notInWorkspace;
        }
    }

    static class BatchFileCopier
    extends MasterToSlaveFileCallable<CopyResult> {
        private static final long serialVersionUID = 1L;
        private static final PathUtil PATH_UTIL = new PathUtil();
        private static final FilePermissionEnforcer PERMISSION_ENFORCER = new FilePermissionEnforcer();
        private final Report report;
        private final HashSet<String> permittedAbsolutePaths;
        private final FilteredLog log;
        private final HashSet<String> filesToSkip;
        private final String reportId;

        BatchFileCopier(Report report, Set<String> permittedAbsolutePaths, FilteredLog log, Set<String> filesToSkip) {
            this.report = report;
            this.permittedAbsolutePaths = new HashSet<String>(permittedAbsolutePaths);
            this.log = log;
            this.filesToSkip = new HashSet<String>(filesToSkip);
            this.reportId = report.getId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CopyResult invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
            FilePath workspacePath = new FilePath(workspace);
            List<ValidationResult> validationResults = ((Stream)this.report.stream().parallel()).filter(issue -> !this.filesToSkip.contains(issue.getFileName())).map(issue -> this.validateIssueFile((Issue)issue, workspacePath)).toList();
            Map<String, FilePath> filesToCopy = validationResults.stream().filter(result -> result.filePath != null).collect(Collectors.toMap(result -> result.fileName, result -> result.filePath, (existing, replacement) -> existing));
            int notFound = (int)validationResults.stream().filter(result -> result.status == ValidationStatus.NOT_FOUND).count();
            int notInWorkspace = (int)validationResults.stream().filter(result -> result.status == ValidationStatus.NOT_IN_WORKSPACE).count();
            if (filesToCopy.isEmpty()) {
                return new CopyResult(0, notFound, notInWorkspace);
            }
            Path temporaryFolder = Files.createTempDirectory("affected-files-" + this.reportId + "-", new FileAttribute[0]);
            try {
                int copied = this.zipIndividualFilesInParallel(filesToCopy, temporaryFolder);
                this.createBatchZipInWorkspace(workspacePath, temporaryFolder);
                CopyResult copyResult = new CopyResult(copied, notFound, notInWorkspace);
                return copyResult;
            }
            finally {
                this.deleteFolder(temporaryFolder.toFile());
            }
        }

        private int zipIndividualFilesInParallel(Map<String, FilePath> filesToCopy, Path temporaryFolder) {
            return filesToCopy.entrySet().parallelStream().mapToInt(entry -> this.zipSingleFile((String)entry.getKey(), (FilePath)entry.getValue(), temporaryFolder)).sum();
        }

        private int zipSingleFile(String fileName, FilePath sourceFile, Path temporaryFolder) {
            try {
                String zipName = AffectedFilesResolver.getZipName(fileName);
                Path zipPath = temporaryFolder.resolve(zipName);
                FilePath zipFile = new FilePath(zipPath.toFile());
                sourceFile.zip(zipFile);
                return 1;
            }
            catch (IOException | InterruptedException exception) {
                this.log.logError("- '%s', IO exception has been thrown: %s", new Object[]{sourceFile.getRemote(), exception.getMessage()});
                return 0;
            }
        }

        private void createBatchZipInWorkspace(FilePath workspacePath, Path temporaryFolder) throws IOException {
            FilePath batchZipPath = workspacePath.child(AffectedFilesResolver.getBatchZipFileName(this.reportId));
            this.createBatchZipOnAgent(temporaryFolder, batchZipPath);
        }

        private void createBatchZipOnAgent(Path temporaryFolder, FilePath batchZipPath) throws IOException {
            try (Stream<Path> zipFiles = Files.list(temporaryFolder);
                 ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(Path.of(batchZipPath.getRemote(), new String[0]), new OpenOption[0]));){
                for (File zipFile : (File[])zipFiles.map(Path::toFile).filter(file -> file.getName().endsWith(AffectedFilesResolver.ZIP_EXTENSION)).toArray(File[]::new)) {
                    this.addFileToZip(zipFile, zipOutputStream);
                }
            }
        }

        private void addFileToZip(File zipFile, ZipOutputStream zipOutputStream) throws IOException {
            ZipEntry zipEntry = new ZipEntry(zipFile.getName());
            zipOutputStream.putNextEntry(zipEntry);
            try (InputStream fileInputStream = Files.newInputStream(zipFile.toPath(), new OpenOption[0]);){
                fileInputStream.transferTo(zipOutputStream);
            }
            zipOutputStream.closeEntry();
        }

        private void deleteFolder(File folder) {
            if (!folder.isDirectory()) {
                folder.delete();
                return;
            }
            File[] files = folder.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.deleteFolder(file);
                        continue;
                    }
                    file.delete();
                }
            }
            folder.delete();
        }

        private ValidationResult validateIssueFile(Issue issue, FilePath workspacePath) {
            try {
                Optional<FilePath> sourceFileOptional = this.findSourceFile(issue, workspacePath);
                if (sourceFileOptional.isEmpty()) {
                    return new ValidationResult(issue.getFileName(), null, ValidationStatus.NOT_FOUND);
                }
                FilePath sourceFile = sourceFileOptional.get();
                String sourceFileAbsPath = PATH_UTIL.getAbsolutePath(sourceFile.getRemote());
                if (!PERMISSION_ENFORCER.isInWorkspace(sourceFileAbsPath, workspacePath, this.permittedAbsolutePaths)) {
                    return new ValidationResult(issue.getFileName(), null, ValidationStatus.NOT_IN_WORKSPACE);
                }
                if (!sourceFile.toVirtualFile().canRead()) {
                    this.log.logError("- '%s', cannot read file", new Object[]{issue.getAbsolutePath()});
                    return new ValidationResult(issue.getFileName(), null, ValidationStatus.CANNOT_READ);
                }
                return new ValidationResult(issue.getFileName(), sourceFile, ValidationStatus.VALID);
            }
            catch (IOException | InterruptedException exception) {
                this.log.logError("- '%s', exception during validation: %s", new Object[]{issue.getAbsolutePath(), exception.getMessage()});
                return new ValidationResult(issue.getFileName(), null, ValidationStatus.ERROR);
            }
        }

        private Optional<FilePath> findSourceFile(Issue issue, FilePath workspacePath) throws IOException, InterruptedException {
            FilePath absolutePath = new FilePath(new File(issue.getAbsolutePath()));
            if (absolutePath.exists()) {
                return Optional.of(absolutePath);
            }
            FilePath relativePath = workspacePath.child(issue.getFileName());
            if (relativePath.exists()) {
                return Optional.of(relativePath);
            }
            return Optional.empty();
        }

        private static class ValidationResult {
            private final String fileName;
            private final FilePath filePath;
            private final ValidationStatus status;

            ValidationResult(String fileName, FilePath filePath, ValidationStatus status) {
                this.fileName = fileName;
                this.filePath = filePath;
                this.status = status;
            }
        }

        private static enum ValidationStatus {
            VALID,
            NOT_FOUND,
            NOT_IN_WORKSPACE,
            CANNOT_READ,
            ERROR;

        }
    }
}

