/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.analysis.core.filter.RegexpFilter;
import io.jenkins.plugins.analysis.core.model.Tool;
import io.jenkins.plugins.analysis.core.steps.AnalysisExecution;
import io.jenkins.plugins.analysis.core.steps.AnalysisStepDescriptor;
import io.jenkins.plugins.analysis.core.steps.AnnotatedReport;
import io.jenkins.plugins.analysis.core.steps.IssuesScanner;
import io.jenkins.plugins.analysis.core.steps.Messages;
import io.jenkins.plugins.prism.SourceCodeDirectory;
import io.jenkins.plugins.prism.SourceCodeRetention;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.collections.impl.factory.Sets;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ScanForIssuesStep
extends Step {
    private Tool tool;
    private String sourceCodeEncoding = "";
    private Set<SourceCodeDirectory> sourceDirectories = new HashSet<SourceCodeDirectory>();
    private SourceCodeRetention sourceCodeRetention = SourceCodeRetention.EVERY_BUILD;
    private boolean skipBlames;
    private boolean skipPostProcessing;
    private boolean quiet;
    private List<RegexpFilter> filters = new ArrayList<RegexpFilter>();
    private String scm = "";
    private String sourcePathPrefix = "";
    private String targetPathPrefix = "";

    @DataBoundConstructor
    public ScanForIssuesStep() {
    }

    @CheckForNull
    public Tool getTool() {
        return this.tool;
    }

    @DataBoundSetter
    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public List<RegexpFilter> getFilters() {
        return this.filters;
    }

    @DataBoundSetter
    public void setFilters(List<RegexpFilter> filters) {
        this.filters = new ArrayList<RegexpFilter>(filters);
    }

    @DataBoundSetter
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    @DataBoundSetter
    public void setScm(String scm) {
        this.scm = scm;
    }

    public String getScm() {
        return this.scm;
    }

    public boolean isSkipBlames() {
        return this.skipBlames;
    }

    @DataBoundSetter
    public void setSkipBlames(boolean skipBlames) {
        this.skipBlames = skipBlames;
    }

    @Deprecated
    @DataBoundSetter
    public void setBlameDisabled(boolean blameDisabled) {
        this.skipBlames = blameDisabled;
    }

    @Deprecated
    public boolean isBlameDisabled() {
        return this.skipBlames;
    }

    public boolean isSkipPostProcessing() {
        return this.skipPostProcessing;
    }

    @DataBoundSetter
    public void setSkipPostProcessing(boolean skipPostProcessing) {
        this.skipPostProcessing = skipPostProcessing;
    }

    @CheckForNull
    public String getSourceCodeEncoding() {
        return this.sourceCodeEncoding;
    }

    @DataBoundSetter
    public void setSourceCodeEncoding(String sourceCodeEncoding) {
        this.sourceCodeEncoding = sourceCodeEncoding;
    }

    @DataBoundSetter
    public void setSourceDirectories(List<SourceCodeDirectory> sourceDirectories) {
        this.sourceDirectories = new HashSet<SourceCodeDirectory>(sourceDirectories);
    }

    public List<SourceCodeDirectory> getSourceDirectories() {
        return new ArrayList<SourceCodeDirectory>(this.sourceDirectories);
    }

    private Set<String> getAllSourceDirectories() {
        return this.getSourceDirectories().stream().map(SourceCodeDirectory::getPath).collect(Collectors.toSet());
    }

    @DataBoundSetter
    public void setSourceCodeRetention(SourceCodeRetention sourceCodeRetention) {
        this.sourceCodeRetention = sourceCodeRetention;
    }

    public SourceCodeRetention getSourceCodeRetention() {
        return this.sourceCodeRetention;
    }

    @DataBoundSetter
    public void setSourcePathPrefix(String sourcePathPrefix) {
        this.sourcePathPrefix = sourcePathPrefix;
    }

    public String getSourcePathPrefix() {
        return this.sourcePathPrefix;
    }

    @DataBoundSetter
    public void setTargetPathPrefix(String targetPathPrefix) {
        this.targetPathPrefix = targetPathPrefix;
    }

    public String getTargetPathPrefix() {
        return this.targetPathPrefix;
    }

    public StepExecution start(StepContext context) {
        return new Execution(context, this);
    }

    @SuppressFBWarnings(value={"THROWS"}, justification="false positive")
    static class Execution
    extends AnalysisExecution<AnnotatedReport> {
        private static final long serialVersionUID = -4627988939459725361L;
        private final Tool tool;
        private final String sourceCodeEncoding;
        private final boolean isBlameDisabled;
        private final boolean skipPostProcessing;
        private final List<RegexpFilter> filters;
        private final Set<String> sourceDirectories;
        private final String scm;
        private final boolean quiet;
        private final SourceCodeRetention sourceCodeRetention;
        private final String sourcePathPrefix;
        private final String targetPathPrefix;

        Execution(@NonNull StepContext context, ScanForIssuesStep step) {
            super(context);
            this.tool = step.getTool();
            this.sourceCodeEncoding = step.getSourceCodeEncoding();
            this.isBlameDisabled = step.isSkipBlames();
            this.filters = step.getFilters();
            this.sourceDirectories = step.getAllSourceDirectories();
            this.sourceCodeRetention = step.getSourceCodeRetention();
            this.scm = step.getScm();
            this.skipPostProcessing = step.isSkipPostProcessing();
            this.quiet = step.isQuiet();
            this.sourcePathPrefix = step.getSourcePathPrefix();
            this.targetPathPrefix = step.getTargetPathPrefix();
        }

        protected AnnotatedReport run() throws IOException, InterruptedException, IllegalStateException {
            FilePath workspace = this.getWorkspace();
            TaskListener listener = this.getTaskListener();
            IssuesScanner issuesScanner = new IssuesScanner(this.tool, this.filters, this.getCharset(this.sourceCodeEncoding), workspace, this.sourceDirectories, this.sourceCodeRetention, this.getRun(), new FilePath(this.getRun().getRootDir()), listener, this.scm, this.isBlameDisabled ? IssuesScanner.BlameMode.DISABLED : IssuesScanner.BlameMode.ENABLED, this.skipPostProcessing ? IssuesScanner.PostProcessingMode.DISABLED : IssuesScanner.PostProcessingMode.ENABLED, this.quiet, this.sourcePathPrefix, this.targetPathPrefix);
            return issuesScanner.scan();
        }
    }

    @Extension
    public static class Descriptor
    extends AnalysisStepDescriptor {
        public Set<Class<?>> getRequiredContext() {
            return Sets.immutable.of(FilePath.class, EnvVars.class, TaskListener.class, Run.class).castToSet();
        }

        public String getFunctionName() {
            return "scanForIssues";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.ScanForIssues_DisplayName();
        }
    }
}

