/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.Generated;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.DescriptionProvider;
import io.jenkins.plugins.analysis.core.model.DetailsTableModel;
import io.jenkins.plugins.analysis.core.model.FileNameRenderer;
import io.jenkins.plugins.analysis.core.model.IssuesModel;
import io.jenkins.plugins.analysis.core.model.Messages;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import java.util.Locale;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jvnet.localizer.Localizable;

public class StaticAnalysisLabelProvider
implements DescriptionProvider {
    @VisibleForTesting
    public static final String ANALYSIS_SVG_ICON = "symbol-solid/triangle-exclamation plugin-font-awesome-api";
    protected static final DescriptionProvider EMPTY_DESCRIPTION = Issue::getDescription;
    private final String id;
    private final String icon;
    @CheckForNull
    private String name;
    private final DescriptionProvider descriptionProvider;

    @VisibleForTesting
    StaticAnalysisLabelProvider(String id) {
        this(id, "", EMPTY_DESCRIPTION);
    }

    public StaticAnalysisLabelProvider(String id, @CheckForNull String name) {
        this(id, name, EMPTY_DESCRIPTION);
    }

    public StaticAnalysisLabelProvider(String id, @CheckForNull String name, DescriptionProvider descriptionProvider) {
        this(id, name, descriptionProvider, Report.IssueType.WARNING);
    }

    public StaticAnalysisLabelProvider(String id, @CheckForNull String name, DescriptionProvider descriptionProvider, Report.IssueType type) {
        this.id = id;
        this.descriptionProvider = descriptionProvider;
        this.icon = this.getIcon(type);
        this.changeName(name);
    }

    private String getIcon(Report.IssueType type) {
        return switch (type) {
            case Report.IssueType.BUG -> "symbol-solid/bug plugin-font-awesome-api";
            case Report.IssueType.DUPLICATION -> "symbol-regular/clone plugin-font-awesome-api";
            case Report.IssueType.VULNERABILITY -> "symbol-solid/shield-halved plugin-font-awesome-api";
            default -> ANALYSIS_SVG_ICON;
        };
    }

    private void changeName(String originalName) {
        if (StringUtils.isNotBlank((CharSequence)originalName) && !"-".equals(originalName)) {
            this.name = originalName;
        }
    }

    public DetailsTableModel getIssuesModel(Run<?, ?> build, String url, Report report) {
        return new IssuesModel(report, this.getFileNameRenderer(build), this.getAgeBuilder(build, url), this);
    }

    protected DefaultAgeBuilder getAgeBuilder(Run<?, ?> owner, String url) {
        return new DefaultAgeBuilder(owner.getNumber(), url, owner.getParent());
    }

    protected FileNameRenderer getFileNameRenderer(Run<?, ?> owner) {
        return new FileNameRenderer(owner);
    }

    @VisibleForTesting
    String getDefaultName() {
        return Messages.Tool_Default_Name();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            return this.name;
        }
        return this.getDefaultName();
    }

    public StaticAnalysisLabelProvider setName(@CheckForNull String name) {
        this.changeName(name);
        return this;
    }

    @Generated
    public String toString() {
        return "%s: %s".formatted(this.getId(), this.getName());
    }

    public String getLinkName() {
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            return Messages.Tool_Link_Name(this.name);
        }
        return Messages.Tool_Link_Name(this.getDefaultName());
    }

    public String getTrendName() {
        return Messages.Tool_Trend_Name(this.getName());
    }

    public String getSmallIconUrl() {
        return this.icon;
    }

    public String getLargeIconUrl() {
        return this.icon;
    }

    public String getToolTip(int numberOfItems) {
        return this.getToolTipLocalizable(numberOfItems).toString();
    }

    Localizable getToolTipLocalizable(int numberOfItems) {
        return new CompositeLocalizable(this.getName(), this.createToolTipSuffix(numberOfItems));
    }

    private Localizable createToolTipSuffix(int numberOfItems) {
        if (numberOfItems == 0) {
            return Messages._Tool_NoIssues();
        }
        if (numberOfItems == 1) {
            return Messages._Tool_OneIssue();
        }
        return Messages._Tool_MultipleIssues(numberOfItems);
    }

    @Override
    public String getDescription(Issue issue) {
        return this.descriptionProvider.getDescription(issue);
    }

    public String getSourceCodeDescription(Run<?, ?> build, Issue issue) {
        return this.getDescription(issue);
    }

    public static class DefaultAgeBuilder
    implements AgeBuilder {
        private final int currentBuildNumber;
        private final String resultUrl;
        @CheckForNull
        private Job<?, ?> owner;

        @Deprecated
        public DefaultAgeBuilder(int currentBuildNumber, String resultUrl) {
            this.currentBuildNumber = currentBuildNumber;
            this.resultUrl = resultUrl;
        }

        public DefaultAgeBuilder(int currentBuildNumber, String resultUrl, Job<?, ?> job) {
            this(currentBuildNumber, resultUrl);
            this.owner = job;
        }

        @Override
        public String apply(Integer referenceBuild) {
            if (referenceBuild >= this.currentBuildNumber || referenceBuild <= 0) {
                return "1";
            }
            String referenceBuildId = String.valueOf(referenceBuild);
            if (this.owner != null && this.owner.getBuild(referenceBuildId) == null) {
                return this.computeAge(referenceBuild);
            }
            String cleanUrl = StringUtils.stripEnd((String)this.resultUrl, (String)"/");
            int subDetailsCount = StringUtils.countMatches((CharSequence)cleanUrl, (CharSequence)"/");
            String backward = StringUtils.repeat((String)"../", (int)(subDetailsCount + 2));
            String detailsUrl = StringUtils.substringBefore((String)cleanUrl, (String)"/");
            String url = "%s%d/%s".formatted(backward, referenceBuild, detailsUrl);
            return ((ContainerTag)TagCreator.a((String)this.computeAge(referenceBuild)).withHref(StringUtils.stripEnd((String)url, (String)"/"))).render();
        }

        private String computeAge(int buildNumber) {
            return String.valueOf(this.currentBuildNumber - buildNumber + 1);
        }
    }

    @FunctionalInterface
    public static interface AgeBuilder
    extends Function<Integer, String> {
    }

    static class CompositeLocalizable
    extends Localizable {
        private static final long serialVersionUID = 2819361593374249688L;
        private final String prefix;
        private final Localizable suffix;

        CompositeLocalizable(String prefix, Localizable suffix) {
            super(null, suffix.getKey(), new Object[0]);
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String toString(Locale locale) {
            return "%s: %s".formatted(this.prefix, this.suffix);
        }
    }
}

