/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import io.jenkins.plugins.analysis.core.model.DescriptionProvider;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;

public class IconLabelProvider
extends StaticAnalysisLabelProvider {
    private static final String ICONS_URL = "/plugin/warnings-ng/icons/";
    private final String smallIconUrl;
    private final String largeIconUrl;

    public IconLabelProvider(String id, String name) {
        this(id, name, EMPTY_DESCRIPTION);
    }

    public IconLabelProvider(String id, String name, DescriptionProvider descriptionProvider) {
        this(id, name, descriptionProvider, id);
    }

    public IconLabelProvider(String id, String name, DescriptionProvider descriptionProvider, String iconName) {
        super(id, name, descriptionProvider);
        String prefix = ICONS_URL + iconName;
        this.smallIconUrl = prefix + "-24x24.png";
        this.largeIconUrl = prefix + "-48x48.png";
    }

    @Override
    public String getSmallIconUrl() {
        return this.smallIconUrl;
    }

    @Override
    public String getLargeIconUrl() {
        return this.largeIconUrl;
    }
}

