/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.ResultSelector;
import java.util.List;
import java.util.Optional;

public class ByIdResultSelector
implements ResultSelector {
    private final String id;

    public ByIdResultSelector(String id) {
        this.id = id;
    }

    @Override
    public Optional<ResultAction> get(Run<?, ?> build) {
        List actions = build.getActions(ResultAction.class);
        for (ResultAction action : actions) {
            if (!this.id.equals(action.getId())) continue;
            return Optional.of(action);
        }
        return Optional.empty();
    }

    public String toString() {
        return "%s with ID %s".formatted(ResultAction.class.getName(), this.id);
    }
}

