/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.charts;

import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import io.jenkins.plugins.analysis.core.charts.SeverityPalette;
import io.jenkins.plugins.analysis.core.charts.SeveritySeriesBuilder;
import io.jenkins.plugins.analysis.core.charts.TrendChart;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import io.jenkins.plugins.analysis.core.util.LocalizedSeverity;
import java.util.List;

public class SeverityTrendChart
implements TrendChart {
    @Override
    public LinesChartModel create(Iterable<? extends BuildResult<AnalysisBuildResult>> results, ChartModelConfiguration configuration) {
        SeveritySeriesBuilder builder = new SeveritySeriesBuilder();
        LinesDataSet dataSet = builder.createDataSet(configuration, results);
        return this.createChartFromDataSet(dataSet);
    }

    public LinesChartModel aggregate(List<Iterable<? extends BuildResult<AnalysisBuildResult>>> results, ChartModelConfiguration configuration) {
        SeveritySeriesBuilder builder = new SeveritySeriesBuilder();
        LinesDataSet dataSet = builder.createAggregatedDataSet(configuration, results);
        return this.createChartFromDataSet(dataSet);
    }

    private LinesChartModel createChartFromDataSet(LinesDataSet dataSet) {
        Severity[] visibleSeverities;
        LinesChartModel model = new LinesChartModel(dataSet);
        for (Severity severity : visibleSeverities = new Severity[]{Severity.WARNING_LOW, Severity.WARNING_NORMAL, Severity.WARNING_HIGH, Severity.ERROR}) {
            List values = dataSet.getSeries(severity.getName());
            if (!values.stream().anyMatch(integer -> integer > 0)) continue;
            LineSeries series = this.createSeries(severity);
            series.addAll(values);
            model.addSeries(new LineSeries[]{series});
        }
        return model;
    }

    private LineSeries createSeries(Severity severity) {
        return new LineSeries(LocalizedSeverity.getLocalizedString(severity), SeverityPalette.mapToColor(severity).normal(), LineSeries.StackedMode.STACKED, LineSeries.FilledMode.FILLED);
    }
}

