/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.restapi;

import edu.hm.hafner.analysis.Severity;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ToolApi {
    private final String name;
    private final String id;
    private final String latestUrl;
    private final int size;
    private final Map<Severity, Integer> sizePerSeverity;

    public ToolApi(String id, String name, String latestUrl, int size, Map<Severity, Integer> sizePerSeverity) {
        this.name = name;
        this.id = id;
        this.latestUrl = latestUrl;
        this.size = size;
        this.sizePerSeverity = sizePerSeverity;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public int getSize() {
        return this.size;
    }

    @Exported
    public String getLatestUrl() {
        return this.latestUrl;
    }

    @Exported
    public int getErrorSize() {
        return this.sizePerSeverity.getOrDefault(Severity.ERROR, 0);
    }

    @Exported
    public int getHighSize() {
        return this.sizePerSeverity.getOrDefault(Severity.WARNING_HIGH, 0);
    }

    @Exported
    public int getNormalSize() {
        return this.sizePerSeverity.getOrDefault(Severity.WARNING_NORMAL, 0);
    }

    @Exported
    public int getLowSize() {
        return this.sizePerSeverity.getOrDefault(Severity.WARNING_LOW, 0);
    }
}

