/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class PropertyStatistics {
    private final Map<String, ? extends Report> issuesByProperty;
    private final Map<String, ? extends Report> newIssuesByProperty;
    private final Function<String, String> propertyFormatter;
    private final String property;
    private final int total;
    private final int totalNewIssues;

    PropertyStatistics(Report report, Report newIssues, String property, Function<String, String> propertyFormatter) {
        this.property = property;
        this.propertyFormatter = propertyFormatter;
        this.issuesByProperty = report.groupByProperty(property);
        this.newIssuesByProperty = newIssues.groupByProperty(property);
        this.total = report.size();
        this.totalNewIssues = newIssues.size();
    }

    public int getTotal() {
        return this.total;
    }

    public int getTotalNewIssues() {
        return this.totalNewIssues;
    }

    public String getProperty() {
        return this.property;
    }

    public String getDisplayName(String key) {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.propertyFormatter.apply(key), (CharSequence)"-");
    }

    public String getToolTip(String key) {
        if (this.getDisplayName(key).equals(key)) {
            return "";
        }
        return key;
    }

    public Set<String> getKeys() {
        return this.issuesByProperty.keySet();
    }

    public int getMax() {
        return this.issuesByProperty.values().stream().mapToInt(Report::size).max().orElse(0);
    }

    public long getCount(String key) {
        return this.getReportFor(key).size();
    }

    public long getNewCount(String key) {
        return this.getNewReportFor(key).map(Report::size).orElse(0).intValue();
    }

    public long getErrorCount(String key) {
        return this.getReportFor(key).getSizeOf(Severity.ERROR);
    }

    public long getHighCount(String key) {
        return this.getReportFor(key).getSizeOf(Severity.WARNING_HIGH);
    }

    public long getNormalCount(String key) {
        return this.getReportFor(key).getSizeOf(Severity.WARNING_NORMAL);
    }

    public long getLowCount(String key) {
        return this.getReportFor(key).getSizeOf(Severity.WARNING_LOW);
    }

    private Report getReportFor(String key) {
        if (this.issuesByProperty.containsKey(key)) {
            return this.issuesByProperty.get(key);
        }
        throw new NoSuchElementException("There is no report for key '%s'".formatted(key));
    }

    private Optional<Report> getNewReportFor(String key) {
        if (this.newIssuesByProperty.containsKey(key)) {
            return Optional.of(this.newIssuesByProperty.get(key));
        }
        return Optional.empty();
    }
}

