/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.restapi;

import edu.hm.hafner.analysis.Issue;
import io.jenkins.plugins.analysis.core.util.Blame;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class IssueApi {
    private final Issue issue;
    private final Blame blame;

    public IssueApi(Issue issue, Blame blame) {
        this.issue = issue;
        this.blame = blame;
    }

    @Exported
    @Whitelisted
    public String getFileName() {
        return this.issue.getFileName();
    }

    @Exported
    @Whitelisted
    public String getBaseName() {
        return this.issue.getBaseName();
    }

    @Exported
    @Whitelisted
    public String getCategory() {
        return this.issue.getCategory();
    }

    @Exported
    @Whitelisted
    public String getType() {
        return this.issue.getType();
    }

    @Exported
    @Whitelisted
    public String getSeverity() {
        return this.issue.getSeverity().getName();
    }

    @Exported
    @Whitelisted
    public String getMessage() {
        return this.issue.getMessage();
    }

    @Exported
    @Whitelisted
    public String getDescription() {
        return this.issue.getDescription();
    }

    @Exported
    @Whitelisted
    public int getLineStart() {
        return this.issue.getLineStart();
    }

    @Exported
    @Whitelisted
    public int getLineEnd() {
        return this.issue.getLineEnd();
    }

    @Exported
    @Whitelisted
    public int getColumnStart() {
        return this.issue.getColumnStart();
    }

    @Exported
    @Whitelisted
    public int getColumnEnd() {
        return this.issue.getColumnEnd();
    }

    @Exported
    @Whitelisted
    public String getPackageName() {
        return this.issue.getPackageName();
    }

    @Exported
    @Whitelisted
    public String getModuleName() {
        return this.issue.getModuleName();
    }

    @Exported
    @Whitelisted
    public String getOrigin() {
        return this.issue.getOrigin();
    }

    @Exported
    @Whitelisted
    public String getOriginName() {
        return this.issue.getOriginName();
    }

    @Exported
    @Whitelisted
    public String getReference() {
        return this.issue.getReference();
    }

    @Exported
    @Whitelisted
    public String getFingerprint() {
        return this.issue.getFingerprint();
    }

    @Exported
    @Whitelisted
    public String getAuthorName() {
        return this.blame.getAuthorName();
    }

    @Exported
    @Whitelisted
    public String getAuthorEmail() {
        return this.blame.getAuthorEmail();
    }

    @Exported
    @Whitelisted
    public String getCommit() {
        return this.blame.getCommit();
    }

    @Exported
    @Whitelisted
    public int getAddedAt() {
        return this.blame.getAddedAt();
    }

    @Exported
    @Whitelisted
    public String toString() {
        return this.issue.toString();
    }
}

