/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.charts.HealthTrendChart;
import io.jenkins.plugins.analysis.core.charts.NewVersusFixedTrendChart;
import io.jenkins.plugins.analysis.core.charts.SeverityTrendChart;
import io.jenkins.plugins.analysis.core.charts.ToolsTrendChart;
import io.jenkins.plugins.analysis.core.charts.TrendChart;
import io.jenkins.plugins.analysis.core.model.AnalysisHistory;
import io.jenkins.plugins.analysis.core.model.ByIdResultSelector;
import io.jenkins.plugins.analysis.core.model.History;
import io.jenkins.plugins.analysis.core.model.NullAnalysisHistory;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import io.jenkins.plugins.analysis.core.util.TrendChartType;
import io.jenkins.plugins.echarts.AsyncConfigurableTrendChart;
import java.io.IOException;
import java.util.Optional;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class JobAction
implements Action,
AsyncConfigurableTrendChart {
    private static final JacksonFacade JACKSON_FACADE = new JacksonFacade();
    private static final String NEW_ISSUES_TREND_ID = "new";
    private static final String HEALTH_REPORT_TREND_ID = "health";
    private final Job<?, ?> owner;
    private final StaticAnalysisLabelProvider labelProvider;
    private final int numberOfTools;
    private final TrendChartType trendChartType;
    private final String urlName;

    @Deprecated
    public JobAction(Job<?, ?> owner, StaticAnalysisLabelProvider labelProvider, int numberOfTools) {
        this(owner, labelProvider, numberOfTools, TrendChartType.TOOLS_ONLY, labelProvider.getId());
    }

    @Deprecated
    public JobAction(Job<?, ?> owner, StaticAnalysisLabelProvider labelProvider, int numberOfTools, TrendChartType trendChartType) {
        this(owner, labelProvider, numberOfTools, trendChartType, labelProvider.getId());
    }

    public JobAction(Job<?, ?> owner, StaticAnalysisLabelProvider labelProvider, int numberOfTools, TrendChartType trendChartType, String urlName) {
        this.urlName = urlName;
        this.owner = owner;
        this.labelProvider = labelProvider;
        this.numberOfTools = numberOfTools;
        this.trendChartType = trendChartType;
    }

    public String getId() {
        return this.urlName;
    }

    public String getDisplayName() {
        return this.labelProvider.getLinkName();
    }

    public String getTrendName() {
        return this.labelProvider.getTrendName();
    }

    public Job<?, ?> getOwner() {
        return this.owner;
    }

    public History createBuildHistory() {
        Run lastCompletedBuild = this.owner.getLastCompletedBuild();
        if (lastCompletedBuild == null) {
            return new NullAnalysisHistory();
        }
        return new AnalysisHistory(lastCompletedBuild, new ByIdResultSelector(this.getId()));
    }

    @CheckForNull
    public String getIconFileName() {
        return this.labelProvider.getSmallIconUrl();
    }

    public String getUrlName() {
        return this.urlName;
    }

    public void doIndex(StaplerRequest2 request, StaplerResponse2 response) throws IOException {
        Optional<ResultAction> action = this.getLatestAction();
        if (action.isPresent()) {
            response.sendRedirect2("../%d/%s".formatted(action.get().getOwner().getNumber(), this.getId()));
        }
    }

    public Optional<ResultAction> getLatestAction() {
        return this.createBuildHistory().getBaselineAction();
    }

    @JavaScriptMethod
    public String getConfigurableBuildTrendModel(String configuration) {
        String chartType = JACKSON_FACADE.getString(configuration, "chartType", "severity");
        return new JacksonFacade().toJson((Object)this.selectChart(chartType).create(this.createBuildHistory(), ChartModelConfiguration.fromJson((String)configuration)));
    }

    private TrendChart selectChart(String chartType) {
        Optional<ResultAction> latestAction;
        if (NEW_ISSUES_TREND_ID.equals(chartType)) {
            return new NewVersusFixedTrendChart();
        }
        if (HEALTH_REPORT_TREND_ID.equals(chartType) && (latestAction = this.getLatestAction()).isPresent()) {
            return new HealthTrendChart(latestAction.get().getHealthDescriptor());
        }
        if (this.numberOfTools > 1) {
            return new ToolsTrendChart();
        }
        return new SeverityTrendChart();
    }

    public boolean isTrendVisible() {
        return this.isTrendEnabled() && this.createBuildHistory().hasMultipleResults();
    }

    private boolean isTrendEnabled() {
        return this.trendChartType != TrendChartType.NONE && this.trendChartType != TrendChartType.AGGREGATION_ONLY;
    }

    public boolean isTrendEmpty() {
        History results = this.createBuildHistory();
        for (BuildResult<AnalysisBuildResult> result : results) {
            if (((AnalysisBuildResult)result.getResult()).getTotalSize() <= 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "%s (%s)".formatted(this.getClass().getName(), this.labelProvider.getName());
    }
}

