/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.tasks;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.Report;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Run;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.model.SymbolIconLabelProvider;
import io.jenkins.plugins.analysis.core.model.Tool;
import io.jenkins.plugins.analysis.warnings.Messages;
import io.jenkins.plugins.analysis.warnings.tasks.AgentScanner;
import io.jenkins.plugins.analysis.warnings.tasks.TaskScanner;
import io.jenkins.plugins.analysis.warnings.tasks.TaskScannerBuilder;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.LogHandler;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class OpenTasks
extends Tool {
    private static final long serialVersionUID = 4692318309214830824L;
    private static final String ID = "open-tasks";
    private String highTags = "";
    private String normalTags = "";
    private String lowTags = "";
    private boolean ignoreCase;
    private boolean isRegularExpression;
    private String includePattern = "";
    private String excludePattern = "";

    public String getIncludePattern() {
        return this.includePattern;
    }

    @DataBoundSetter
    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    @DataBoundSetter
    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public String getHighTags() {
        return this.highTags;
    }

    @DataBoundSetter
    public void setHighTags(String highTags) {
        this.highTags = highTags;
    }

    public String getNormalTags() {
        return this.normalTags;
    }

    @DataBoundSetter
    public void setNormalTags(String normalTags) {
        this.normalTags = normalTags;
    }

    public String getLowTags() {
        return this.lowTags;
    }

    @DataBoundSetter
    public void setLowTags(String lowTags) {
        this.lowTags = lowTags;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    @DataBoundSetter
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean getIsRegularExpression() {
        return this.isRegularExpression;
    }

    @DataBoundSetter
    public void setIsRegularExpression(boolean isRegularExpression) {
        this.isRegularExpression = isRegularExpression;
    }

    @Override
    public Report scan(Run<?, ?> run, FilePath workspace, Charset sourceCodeEncoding, LogHandler logger) {
        try {
            Report openTasks = (Report)workspace.act((FilePath.FileCallable)new AgentScanner(this.highTags, this.normalTags, this.lowTags, this.ignoreCase ? TaskScanner.CaseMode.IGNORE_CASE : TaskScanner.CaseMode.CASE_SENSITIVE, this.isRegularExpression ? TaskScanner.MatcherMode.REGEXP_MATCH : TaskScanner.MatcherMode.STRING_MATCH, this.includePattern, this.excludePattern, sourceCodeEncoding.name()));
            openTasks.setOrigin(this.getActualId(), this.getActualName());
            return openTasks;
        }
        catch (IOException e) {
            Report report = new Report();
            report.logException((Exception)e, "Exception while reading the source code files:", new Object[0]);
            return report;
        }
        catch (InterruptedException e) {
            throw new ParsingCanceledException((Throwable)e);
        }
    }

    @DataBoundConstructor
    public OpenTasks() {
    }

    @Symbol(value={"taskScanner"})
    @Extension
    public static class Descriptor
    extends Tool.ToolDescriptor {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();
        private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();

        public Descriptor() {
            super(OpenTasks.ID);
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Warnings_OpenTasks_Name();
        }

        @Override
        public StaticAnalysisLabelProvider getLabelProvider() {
            return new LabelProvider();
        }

        @POST
        public FormValidation doCheckIncludePattern(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String includePattern) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.doCheckPattern(project, includePattern);
        }

        @POST
        public FormValidation doCheckExcludePattern(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String excludePattern) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.doCheckPattern(project, excludePattern);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @POST
        public FormValidation doCheckExample(@AncestorInPath BuildableItem project, @QueryParameter String example, @QueryParameter String high, @QueryParameter String normal, @QueryParameter String low, @QueryParameter boolean ignoreCase, @QueryParameter boolean asRegexp) {
            if (StringUtils.isEmpty((CharSequence)example) || !JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            TaskScannerBuilder builder = new TaskScannerBuilder();
            TaskScanner scanner = builder.setHighTasks(high).setNormalTasks(normal).setLowTasks(low).setCaseMode(ignoreCase ? TaskScanner.CaseMode.IGNORE_CASE : TaskScanner.CaseMode.CASE_SENSITIVE).setMatcherMode(asRegexp ? TaskScanner.MatcherMode.REGEXP_MATCH : TaskScanner.MatcherMode.STRING_MATCH).build();
            if (scanner.isInvalidPattern()) {
                return FormValidation.error((String)scanner.getErrors());
            }
            try (BufferedReader reader = new BufferedReader(new StringReader(example));){
                Report tasks;
                IssueBuilder issueBuilder;
                block19: {
                    block18: {
                        FormValidation formValidation;
                        issueBuilder = new IssueBuilder();
                        try {
                            issueBuilder.setFileName("UI example");
                            tasks = scanner.scanTasks(reader.lines().iterator(), issueBuilder);
                            if (!tasks.isEmpty()) break block18;
                            formValidation = FormValidation.warning((String)Messages.OpenTasks_Validation_NoTask());
                        }
                        catch (Throwable throwable) {
                            try {
                                issueBuilder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        issueBuilder.close();
                        return formValidation;
                    }
                    if (tasks.size() == 1) break block19;
                    FormValidation formValidation = FormValidation.warning((String)Messages.OpenTasks_Validation_MultipleTasks(tasks.size()));
                    issueBuilder.close();
                    return formValidation;
                }
                Issue task = tasks.get(0);
                FormValidation formValidation = FormValidation.ok((String)Messages.OpenTasks_Validation_OneTask(task.getType(), task.getMessage()));
                issueBuilder.close();
                return formValidation;
            }
            catch (IOException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }

    private static class LabelProvider
    extends SymbolIconLabelProvider {
        LabelProvider() {
            super(OpenTasks.ID, Messages.Warnings_OpenTasks_Name(), (Issue i) -> "", "symbol-solid/clipboard-check plugin-font-awesome-api");
        }

        @Override
        public String getLinkName() {
            return Messages.Warnings_OpenTasks_LinkName();
        }

        @Override
        public String getTrendName() {
            return Messages.Warnings_OpenTasks_TrendName();
        }
    }
}

