/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.axivion;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.gson.JsonObject;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.analysis.core.model.IconLabelProvider;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.model.Tool;
import io.jenkins.plugins.analysis.warnings.axivion.AxIssueKind;
import io.jenkins.plugins.analysis.warnings.axivion.AxivionParser;
import io.jenkins.plugins.analysis.warnings.axivion.RemoteAxivionDashboard;
import io.jenkins.plugins.util.EnvironmentResolver;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.LogHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.utils.URIBuilder;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public final class AxivionSuite
extends Tool {
    private static final long serialVersionUID = 967222727302169818L;
    private static final String ID = "axivion-suite";
    private static final String NAME = "Axivion Suite";
    private String projectUrl = "";
    private String credentialsId = "";
    private String basedir = "$";
    private String namedFilter = "";
    private boolean ignoreSuppressedOrJustified = true;

    @VisibleForTesting
    AxivionSuite(String projectUrl, String credentialsId, String basedir) {
        this.setBasedir(basedir);
        this.setCredentialsId(credentialsId);
        this.setProjectUrl(projectUrl);
    }

    @DataBoundConstructor
    public AxivionSuite() {
    }

    public String getBasedir() {
        return this.basedir;
    }

    @DataBoundSetter
    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    @DataBoundSetter
    public void setProjectUrl(String projectUrl) {
        try {
            URL url = new URL(projectUrl);
            this.projectUrl = new URIBuilder().setCharset(StandardCharsets.UTF_8).setHost(url.getHost()).setPort(url.getPort()).setPath(url.getPath()).setScheme(url.getProtocol()).build().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Not a valid project url.", e);
        }
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getNamedFilter() {
        return this.namedFilter;
    }

    @DataBoundSetter
    public void setNamedFilter(String namedFilter) {
        this.namedFilter = namedFilter;
    }

    public boolean isIgnoreSuppressedOrJustified() {
        return this.ignoreSuppressedOrJustified;
    }

    @DataBoundSetter
    public void setIgnoreSuppressedOrJustified(boolean ignoreSuppressedOrJustified) {
        this.ignoreSuppressedOrJustified = ignoreSuppressedOrJustified;
    }

    @Override
    protected Object readResolve() {
        if (this.namedFilter == null) {
            this.namedFilter = "";
        }
        return super.readResolve();
    }

    @Override
    public Report scan(Run<?, ?> run, FilePath workspace, Charset sourceCodeEncoding, LogHandler logger) throws ParsingException, ParsingCanceledException {
        UsernamePasswordCredentials httpClientCredentials = this.withValidCredentials((Item)run.getParent());
        RemoteAxivionDashboard dashboard = new RemoteAxivionDashboard(this.projectUrl, httpClientCredentials, this.namedFilter);
        AxivionParser.Config config = new AxivionParser.Config(this.projectUrl, AxivionSuite.expandBaseDir(run, this.basedir), this.ignoreSuppressedOrJustified);
        AxivionParser parser = new AxivionParser(config);
        Report report = new Report(ID, NAME);
        report.logInfo("Axivion webservice: %s", new Object[]{this.projectUrl});
        report.logInfo("Local basedir: %s", new Object[]{this.basedir});
        report.logInfo("Named Filter: %s", new Object[]{this.namedFilter});
        report.logInfo("Ignore suppressed or justified: %s", new Object[]{this.ignoreSuppressedOrJustified});
        for (AxIssueKind kind : AxIssueKind.values()) {
            JsonObject payload = dashboard.getIssues(kind);
            parser.parse(report, kind, payload);
        }
        return report;
    }

    private UsernamePasswordCredentials withValidCredentials(Item context) {
        List all = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)context, null, Collections.emptyList());
        StandardUsernamePasswordCredentials jenkinsCredentials = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)all, (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
        if (jenkinsCredentials == null) {
            throw new ParsingException("Could not find the credentials for " + this.credentialsId, new Object[0]);
        }
        return new UsernamePasswordCredentials(jenkinsCredentials.getUsername(), Secret.toString((Secret)jenkinsCredentials.getPassword()));
    }

    private static String expandBaseDir(Run<?, ?> run, String baseDir) {
        String expandedBasedir;
        try {
            EnvironmentResolver environmentResolver = new EnvironmentResolver();
            expandedBasedir = environmentResolver.expandEnvironmentVariables(run.getEnvironment(TaskListener.NULL), baseDir);
        }
        catch (IOException | InterruptedException ignore) {
            expandedBasedir = baseDir;
        }
        return expandedBasedir;
    }

    @Symbol(value={"axivionSuite", "axivion"})
    @Extension
    public static class AxivionSuiteToolDescriptor
    extends Tool.ToolDescriptor {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();

        public AxivionSuiteToolDescriptor() {
            super(AxivionSuite.ID);
        }

        @NonNull
        public String getDisplayName() {
            return AxivionSuite.NAME;
        }

        @Override
        public String getHelp() {
            return "For using Axivion Suite, set up your analysis project and the web service. Provide the URL and credentials.";
        }

        @Override
        public StaticAnalysisLabelProvider getLabelProvider() {
            return new LabelProvider();
        }

        @POST
        public FormValidation doCheckProjectUrl(@AncestorInPath BuildableItem project, @QueryParameter String projectUrl) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            try {
                new URL(projectUrl).toURI();
                return FormValidation.ok();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                return FormValidation.error((String)"This is not a valid URL.");
            }
        }

        @POST
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
        public FormValidation doCheckBasedir(@AncestorInPath BuildableItem project, @QueryParameter String basedir) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            try {
                if (!basedir.contains("$")) {
                    Path.of(basedir, new String[0]);
                }
                return FormValidation.ok();
            }
            catch (InvalidPathException e) {
                return FormValidation.error((String)"You have to provide a valid path.");
            }
        }

        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            if (StringUtils.isBlank((CharSequence)credentialsId)) {
                return FormValidation.error((String)"You have to provide credentials.");
            }
            if (item == null ? !JENKINS.hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)) == null) {
                return FormValidation.error((String)"Cannot find currently selected credentials.");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !JENKINS.hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            ListBoxModel credentials = CredentialsProvider.listCredentials(StandardUsernamePasswordCredentials.class, (Item)item, null, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.always());
            result.addMissing((Collection)credentials);
            return result.includeCurrentValue(credentialsId);
        }
    }

    private static class LabelProvider
    extends IconLabelProvider {
        LabelProvider() {
            super(AxivionSuite.ID, AxivionSuite.NAME, EMPTY_DESCRIPTION, "axivion");
        }
    }
}

