/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildableItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.LogHandler;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class Tool
extends AbstractDescribableImpl<Tool>
implements Serializable {
    private static final long serialVersionUID = 3305739700153168629L;
    private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();
    private String id = "";
    private String name = "";
    private String icon = "";
    private JenkinsFacade jenkins = new JenkinsFacade();

    @VisibleForTesting
    public void setJenkinsFacade(JenkinsFacade jenkinsFacade) {
        this.jenkins = jenkinsFacade;
    }

    protected Object readResolve() {
        this.jenkins = new JenkinsFacade();
        if (this.icon == null) {
            this.icon = "";
        }
        return this;
    }

    @DataBoundSetter
    public void setId(String id) {
        VALIDATION_UTILITIES.ensureValidId(id);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getActualId() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getId(), (CharSequence)this.getDescriptor().getId());
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getActualName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getName(), (CharSequence)this.getDescriptor().getDisplayName());
    }

    @DataBoundSetter
    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getSymbolName() {
        return this.getDescriptor().getSymbolName();
    }

    public StaticAnalysisLabelProvider getLabelProvider() {
        StaticAnalysisLabelProvider labelProvider = this.getDescriptor().getLabelProvider();
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            labelProvider.setName(this.name);
        }
        return labelProvider;
    }

    public ToolDescriptor getDescriptor() {
        return (ToolDescriptor)this.jenkins.getDescriptorOrDie(this.getClass());
    }

    public abstract Report scan(Run<?, ?> var1, FilePath var2, Charset var3, LogHandler var4) throws ParsingException, ParsingCanceledException;

    public static abstract class ToolDescriptor
    extends Descriptor<Tool> {
        private final String defaultId;

        protected ToolDescriptor(String defaultId) {
            VALIDATION_UTILITIES.ensureValidId(defaultId);
            this.defaultId = defaultId;
        }

        @POST
        public FormValidation doCheckId(@AncestorInPath BuildableItem project, @QueryParameter String id) {
            if (!new JenkinsFacade().hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateId(id);
        }

        public String getId() {
            return this.defaultId;
        }

        public String getName() {
            return this.getDisplayName();
        }

        public String getSymbolName() {
            String[] symbols;
            Symbol annotation = ((Object)((Object)this)).getClass().getAnnotation(Symbol.class);
            if (annotation != null && (symbols = annotation.value()).length > 0) {
                return symbols[0];
            }
            return "unknownSymbol";
        }

        public StaticAnalysisLabelProvider getLabelProvider() {
            return new StaticAnalysisLabelProvider(this.getId(), this.getDisplayName());
        }

        public String getIcon() {
            return this.getLabelProvider().getSmallIconUrl();
        }

        public String getHelp() {
            return "";
        }

        public String getUrl() {
            return "";
        }

        public boolean isPostProcessingEnabled() {
            return true;
        }
    }
}

