/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.steps.AnnotatedReport;
import io.jenkins.plugins.analysis.core.steps.IssuesRecorder;
import io.jenkins.plugins.analysis.core.steps.Messages;
import io.jenkins.plugins.util.ResultHandler;
import io.jenkins.plugins.util.RunResultHandler;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Multimaps;

public class IssuesAggregator
extends MatrixAggregator {
    private final IssuesRecorder recorder;
    private final MutableMultimap<String, AnnotatedReport> resultsPerTool;
    private final Map<AnnotatedReport, String> reportToAxisName;
    private final List<String> names;
    private final ReentrantLock aggregationTableLock;

    public IssuesAggregator(MatrixBuild build, Launcher launcher, BuildListener listener, IssuesRecorder recorder) {
        super(build, launcher, listener);
        this.resultsPerTool = Multimaps.mutable.list.empty();
        this.reportToAxisName = new HashMap<AnnotatedReport, String>();
        this.names = Lists.mutable.empty();
        this.aggregationTableLock = new ReentrantLock();
        this.recorder = recorder;
    }

    @VisibleForTesting
    List<String> getNames() {
        return this.names;
    }

    @VisibleForTesting
    Map<String, RichIterable<AnnotatedReport>> getResultsPerTool() {
        return this.resultsPerTool.toMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endRun(MatrixRun run) {
        this.aggregationTableLock.lock();
        try {
            String axisName = run.getParent().getName();
            this.names.add(axisName);
            List actions = run.getActions(ResultAction.class);
            for (ResultAction action : actions) {
                AnnotatedReport report = this.createReport(action.getId(), action.getResult());
                this.resultsPerTool.put((Object)action.getId(), (Object)report);
                this.reportToAxisName.put(report, axisName);
            }
        }
        finally {
            this.aggregationTableLock.unlock();
        }
        return true;
    }

    private AnnotatedReport createReport(String id, AnalysisResult result) {
        return new AnnotatedReport(id, result.getIssues(), result.getBlames(), result.getForensics());
    }

    public boolean endBuild() {
        this.resultsPerTool.forEachKeyMultiValues((Procedure2 & Serializable)(tool, reports) -> {
            MutableList reportsList = Lists.mutable.withAll(reports);
            reportsList.sortThis(Comparator.comparing(this.reportToAxisName::get));
            AnnotatedReport aggregatedReport = new AnnotatedReport((String)tool, (List<AnnotatedReport>)reportsList);
            this.recorder.publishResult((Run<?, ?>)this.build, this.build.getWorkspace(), (TaskListener)this.listener, Messages.Tool_Default_Name(), aggregatedReport, "", this.recorder.getIcon(), (ResultHandler)new RunResultHandler((Run)this.build));
        });
        return true;
    }
}

