/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.restapi;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import io.jenkins.plugins.analysis.core.restapi.IssueApi;
import io.jenkins.plugins.analysis.core.util.Blame;
import io.jenkins.plugins.forensics.blame.Blames;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ReportApi {
    private final Report report;
    private final Blames blames;

    public ReportApi(Report report, Blames blames) {
        this.report = report;
        this.blames = blames;
    }

    @Exported(inline=true)
    public List<IssueApi> getIssues() {
        return this.map();
    }

    private List<IssueApi> map() {
        return this.report.stream().map(this::createIssueApi).collect(Collectors.toList());
    }

    private IssueApi createIssueApi(Issue issue) {
        return new IssueApi(issue, new Blame(issue, this.blames));
    }

    @Exported
    public int getSize() {
        return this.report.getSize();
    }

    @Exported
    public String toString() {
        return this.report.toString();
    }
}

