/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.charts;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import io.jenkins.plugins.analysis.core.charts.HealthSeriesBuilder;
import io.jenkins.plugins.analysis.core.charts.Messages;
import io.jenkins.plugins.analysis.core.charts.TrendChart;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import io.jenkins.plugins.analysis.core.util.HealthDescriptor;
import io.jenkins.plugins.echarts.JenkinsPalette;

public class HealthTrendChart
implements TrendChart {
    private final HealthDescriptor healthDescriptor;

    public HealthTrendChart(HealthDescriptor healthDescriptor) {
        this.healthDescriptor = healthDescriptor;
    }

    @Override
    public LinesChartModel create(Iterable<? extends BuildResult<AnalysisBuildResult>> results, ChartModelConfiguration configuration) {
        HealthSeriesBuilder builder = new HealthSeriesBuilder(this.healthDescriptor);
        LinesDataSet dataSet = builder.createDataSet(configuration, results);
        LinesChartModel model = new LinesChartModel(dataSet);
        if (this.healthDescriptor.isEnabled()) {
            LineSeries healthy = this.createSeries(Messages.Healthy_Name(), JenkinsPalette.GREEN);
            healthy.addAll(dataSet.getSeries("healthy"));
            LineSeries intermediate = this.createSeries(Messages.Satisfactory_Name(), JenkinsPalette.YELLOW);
            intermediate.addAll(dataSet.getSeries("between"));
            LineSeries unhealthy = this.createSeries(Messages.Unhealthy_Name(), JenkinsPalette.RED);
            unhealthy.addAll(dataSet.getSeries("unhealthy"));
            model.addSeries(new LineSeries[]{healthy, intermediate, unhealthy});
        } else {
            LineSeries total = new LineSeries(Messages.Total_Name(), JenkinsPalette.YELLOW.normal(), LineSeries.StackedMode.SEPARATE_LINES, LineSeries.FilledMode.LINES);
            total.addAll(dataSet.getSeries("total"));
            model.addSeries(new LineSeries[]{total});
        }
        return model;
    }

    private LineSeries createSeries(String name, JenkinsPalette color) {
        return new LineSeries(name, color.normal(), LineSeries.StackedMode.STACKED, LineSeries.FilledMode.FILLED);
    }
}

