/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.groovy;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import io.jenkins.plugins.analysis.warnings.groovy.GroovyExpressionMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DynamicDocumentParser
extends IssueParser {
    private static final long serialVersionUID = -690643673847390322L;
    private final Pattern pattern;
    private static final int NO_LINE_NUMBER_AVAILABLE = 0;
    private final GroovyExpressionMatcher expressionMatcher;

    DynamicDocumentParser(String regexp, String script) {
        this.pattern = Pattern.compile(regexp, 8);
        this.expressionMatcher = new GroovyExpressionMatcher(script);
    }

    public Report parseReport(ReaderFactory reader) throws ParsingException {
        Report report = new Report();
        Matcher matcher = this.pattern.matcher(reader.readString() + "\n");
        while (matcher.find()) {
            this.expressionMatcher.createIssue(matcher, new IssueBuilder(), 0, reader.getFileName()).ifPresent(arg_0 -> ((Report)report).add(arg_0));
            if (!Thread.interrupted()) continue;
            throw new ParsingCanceledException();
        }
        return report;
    }
}

