/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.RevApiInfoExtension;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.AnalysisModelParser;
import io.jenkins.plugins.analysis.core.model.DescriptionProvider;
import io.jenkins.plugins.analysis.core.model.DetailsTableModel;
import io.jenkins.plugins.analysis.core.model.FileNameRenderer;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.warnings.Messages;
import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class RevApi
extends AnalysisModelParser {
    private static final long serialVersionUID = -8571635906342563283L;
    private static final String ID = "revapi";

    @DataBoundConstructor
    public RevApi() {
    }

    public static class RevApiModel
    extends DetailsTableModel {
        RevApiModel(Report report, FileNameRenderer fileNameRenderer, StaticAnalysisLabelProvider.AgeBuilder ageBuilder, DescriptionProvider descriptionProvider, JenkinsFacade jenkinsFacade) {
            super(report, fileNameRenderer, ageBuilder, descriptionProvider, jenkinsFacade);
        }

        @Override
        protected DetailsTableModel.TableRow getRow(Issue issue) {
            return new RevApiRow(this.getAgeBuilder(), this.getFileNameRenderer(), this.getDescriptionProvider(), issue, this.getJenkinsFacade(), issue.getAdditionalProperties());
        }

        public String getId() {
            return "issues";
        }

        public List<TableColumn> getColumns() {
            ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
            columns.add(this.createDetailsColumn());
            TableColumn nameColumn = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.RevApi_Table_Column_Name()).withDataPropertyKey("issueName").withResponsivePriority(100).build();
            columns.add(nameColumn);
            TableColumn oldFileColumn = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.RevApi_Table_Column_oldFile()).withDataPropertyKey("oldFile").withResponsivePriority(50).build();
            columns.add(oldFileColumn);
            TableColumn newFileColumn = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.RevApi_Table_Column_newFile()).withDataPropertyKey("newFile").withResponsivePriority(50).build();
            columns.add(newFileColumn);
            TableColumn categoryColumn = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.RevApi_Table_Column_category()).withDataPropertyKey("category").withResponsivePriority(50).build();
            columns.add(categoryColumn);
            TableColumn binaryColumn = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.RevApi_Table_Column_binary()).withDataPropertyKey("binary").withResponsivePriority(30).build();
            columns.add(binaryColumn);
            TableColumn sourceColumn = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.RevApi_Table_Column_source()).withDataPropertyKey("source").withResponsivePriority(30).build();
            columns.add(sourceColumn);
            columns.add(this.createSeverityColumn());
            columns.add(this.createAgeColumn());
            return columns;
        }

        public static class RevApiRow
        extends DetailsTableModel.TableRow {
            private Map<String, String> severities;
            private final String issueName;
            private final String oldFile;
            private final String newFile;
            private final String severity;
            private String category;

            RevApiRow(StaticAnalysisLabelProvider.AgeBuilder ageBuilder, FileNameRenderer fileNameRenderer, DescriptionProvider descriptionProvider, Issue issue, JenkinsFacade jenkinsFacade, Serializable additionalData) {
                super(ageBuilder, fileNameRenderer, descriptionProvider, issue, jenkinsFacade);
                if (!(additionalData instanceof RevApiInfoExtension)) {
                    throw new IllegalStateException("Additional info of revApi Issue not an instance of RevApiInfoExtension");
                }
                RevApiInfoExtension revApiInfo = (RevApiInfoExtension)additionalData;
                this.oldFile = revApiInfo.getOldFile();
                this.newFile = revApiInfo.getNewFile();
                this.issueName = revApiInfo.getIssueName();
                this.severities = revApiInfo.getSeverities();
                this.category = issue.getCategory();
                this.severity = this.formatSeverity(issue.getSeverity());
            }

            public String getBinary() {
                return this.severities.get("BINARY");
            }

            public String getSource() {
                return this.severities.get("SOURCE");
            }

            public String getIssueName() {
                return this.issueName;
            }

            public String getOldFile() {
                return this.oldFile;
            }

            public String getNewFile() {
                return this.newFile;
            }

            public String getSeverity() {
                return this.severity;
            }

            public String getCategory() {
                return this.category;
            }

            public void setSeverities(Map<String, String> severities) {
                this.severities = severities;
            }

            public void setCategory(String category) {
                this.category = category;
            }
        }
    }

    private static class RevApiLabelProvider
    extends StaticAnalysisLabelProvider {
        RevApiLabelProvider(String id, String name) {
            super(id, name);
        }

        @Override
        public DetailsTableModel getIssuesModel(Run<?, ?> build, String url, Report report) {
            return new RevApiModel(report, this.getFileNameRenderer(build), this.getAgeBuilder(build, url), this, new JenkinsFacade());
        }
    }

    @Symbol(value={"revApi"})
    @Extension
    public static class Descriptor
    extends AnalysisModelParser.AnalysisModelParserDescriptor {
        public Descriptor() {
            super(RevApi.ID);
        }

        @Override
        public boolean canScanConsoleLog() {
            return false;
        }

        @Override
        public StaticAnalysisLabelProvider getLabelProvider() {
            return new RevApiLabelProvider(this.getId(), this.getDisplayName());
        }
    }
}

