/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.steps.Messages;
import io.jenkins.plugins.analysis.core.util.IssuesStatistics;
import io.jenkins.plugins.checks.api.ChecksAnnotation;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.api.ChecksStatus;
import io.jenkins.plugins.checks.steps.ChecksInfo;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.QualityGateStatus;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.Renderable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;

class WarningChecksPublisher {
    private static final String UNDEFINED_ISSUE_STRING = "-";
    private final ResultAction action;
    private final TaskListener listener;
    @CheckForNull
    private final ChecksInfo checksInfo;

    WarningChecksPublisher(ResultAction action, TaskListener listener, @CheckForNull ChecksInfo checksInfo) {
        this.action = action;
        this.listener = listener;
        this.checksInfo = checksInfo;
    }

    void publishChecks(ChecksAnnotationScope annotationScope) {
        ChecksPublisher publisher = ChecksPublisherFactory.fromRun(this.action.getOwner(), (TaskListener)this.listener);
        publisher.publish(this.extractChecksDetails(annotationScope));
    }

    @VisibleForTesting
    ChecksDetails extractChecksDetails(ChecksAnnotationScope annotationScope) {
        AnalysisResult result = this.action.getResult();
        IssuesStatistics totals = result.getTotals();
        StaticAnalysisLabelProvider labelProvider = this.action.getLabelProvider();
        String checksName = Optional.ofNullable(this.checksInfo).map(ChecksInfo::getName).filter(StringUtils::isNotEmpty).orElse(labelProvider.getName());
        String summary = this.extractChecksSummary(totals) + "\n" + this.extractReferenceBuild(result);
        return new ChecksDetails.ChecksDetailsBuilder().withName(checksName).withStatus(ChecksStatus.COMPLETED).withConclusion(this.extractChecksConclusion(result.getQualityGateResult().getOverallStatus())).withOutput(new ChecksOutput.ChecksOutputBuilder().withTitle(this.extractChecksTitle(totals)).withSummary(summary).withText(this.extractChecksText(totals)).withAnnotations(this.extractChecksAnnotations(this.filterIssuesForAnnotations(annotationScope, result), labelProvider)).build()).withDetailsURL(this.action.getAbsoluteUrl()).build();
    }

    private Report filterIssuesForAnnotations(ChecksAnnotationScope annotationScope, AnalysisResult result) {
        if (annotationScope == ChecksAnnotationScope.SKIP) {
            return new Report();
        }
        if (annotationScope == ChecksAnnotationScope.MODIFIED) {
            return result.getIssues().filter(Issue::isPartOfModifiedCode);
        }
        if (annotationScope == ChecksAnnotationScope.NEW) {
            return result.getNewIssues();
        }
        return result.getIssues();
    }

    private String extractReferenceBuild(AnalysisResult result) {
        return result.getReferenceBuild().map(referenceBuild -> this.getReferenceBuild(result.getId(), (Run<?, ?>)referenceBuild)).map(Renderable::render).orElse("");
    }

    public DomContent getReferenceBuild(String id, Run<?, ?> referenceBuild) {
        return TagCreator.join((Object[])new Object[]{Messages.Tool_ReferenceBuild(), this.createReferenceBuildLink(id, referenceBuild)});
    }

    private ContainerTag createReferenceBuildLink(String id, Run<?, ?> referenceBuild) {
        return (ContainerTag)TagCreator.a((String)referenceBuild.getFullDisplayName()).withHref(new JenkinsFacade().getAbsoluteUrl(new String[]{referenceBuild.getUrl(), id}));
    }

    private String extractChecksTitle(IssuesStatistics statistics) {
        if (statistics.getTotalSize() == 0) {
            return "No issues";
        }
        if (statistics.getNewSize() == 0) {
            return "No new issues, %d total".formatted(statistics.getTotalSize());
        }
        if (statistics.getNewSize() == statistics.getTotalSize()) {
            if (statistics.getNewSize() == 1) {
                return "1 new issue";
            }
            return "%d new issues".formatted(statistics.getNewSize());
        }
        if (statistics.getNewSize() == 1) {
            return "1 new issue, %d total".formatted(statistics.getTotalSize());
        }
        return "%d new issues, %d total".formatted(statistics.getNewSize(), statistics.getTotalSize());
    }

    private String formatColumns(Object ... columns) {
        StringBuilder row = new StringBuilder();
        for (Object column : columns) {
            row.append("|%s".formatted(column));
        }
        row.append('\n');
        return row.toString();
    }

    private String extractChecksSummary(IssuesStatistics statistics) {
        String sizes = this.formatColumns(statistics.getTotalSize(), statistics.getNewSize(), statistics.getTotalSize() - statistics.getNewSize(), statistics.getFixedSize(), this.getTrendEmoji(statistics));
        return this.formatColumns("Total", "New", "Outstanding", "Fixed", "Trend") + this.formatColumns(":-:", ":-:", ":-:", ":-:", ":-:") + sizes;
    }

    private String getTrendEmoji(IssuesStatistics statistics) {
        if (statistics.getTotalSize() == 0) {
            return ":clap:";
        }
        if (statistics.getFixedSize() > statistics.getNewSize()) {
            return ":+1:";
        }
        if (statistics.getNewSize() > 0) {
            return ":-1:";
        }
        return ":zzz:";
    }

    private String extractChecksText(IssuesStatistics statistics) {
        if (statistics.getNewSize() == 0) {
            return "## Severity distribution of all issues\n" + this.generateSeverityText(statistics.getTotalErrorSize(), statistics.getTotalHighSize(), statistics.getTotalNormalSize(), statistics.getTotalLowSize());
        }
        return "## Severity distribution of new issues\n" + this.generateSeverityText(statistics.getNewErrorSize(), statistics.getNewHighSize(), statistics.getNewNormalSize(), statistics.getNewLowSize());
    }

    private String generateSeverityText(int error, int high, int normal, int low) {
        return this.formatColumns("Error", "Warning High", "Warning Normal", "Warning Low") + this.formatColumns(":-:", ":-:", ":-:", ":-:") + this.formatColumns(error, high, normal, low);
    }

    private ChecksConclusion extractChecksConclusion(QualityGateStatus status) {
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case QualityGateStatus.INACTIVE, QualityGateStatus.PASSED -> ChecksConclusion.SUCCESS;
            case QualityGateStatus.FAILED, QualityGateStatus.ERROR, QualityGateStatus.WARNING, QualityGateStatus.NOTE -> ChecksConclusion.FAILURE;
        };
    }

    private List<ChecksAnnotation> extractChecksAnnotations(Report issues, StaticAnalysisLabelProvider labelProvider) {
        ArrayList<ChecksAnnotation> annotations = new ArrayList<ChecksAnnotation>(issues.getSize());
        for (Issue issue : issues) {
            ChecksAnnotation.ChecksAnnotationBuilder builder = new ChecksAnnotation.ChecksAnnotationBuilder().withPath(issue.getFileName()).withTitle(WarningChecksPublisher.getIssueTitle(issue)).withAnnotationLevel(ChecksAnnotation.ChecksAnnotationLevel.WARNING).withMessage(String.valueOf(issue.getSeverity()) + ":\n" + this.parseHtml(issue.getMessage())).withStartLine(Integer.valueOf(issue.getLineStart())).withEndLine(Integer.valueOf(issue.getLineEnd())).withRawDetails(StringUtils.normalizeSpace((String)labelProvider.getDescription(issue)));
            if (issue.getLineStart() == issue.getLineEnd()) {
                builder.withStartColumn(Integer.valueOf(issue.getColumnStart())).withEndColumn(Integer.valueOf(issue.getColumnEnd()));
            }
            annotations.add(builder.build());
        }
        return annotations;
    }

    private String parseHtml(String html) {
        HashSet<String> contents = new HashSet<String>();
        this.parseHtml((Element)Jsoup.parse((String)html), contents);
        return String.join((CharSequence)"\n", contents);
    }

    private void parseHtml(Element html, Set<String> contents) {
        for (TextNode node : html.textNodes()) {
            contents.add(node.text().trim());
        }
        for (Element child : html.children()) {
            if (child.hasAttr("href")) {
                contents.add(child.text().trim() + ":" + child.attr("href").trim());
                continue;
            }
            this.parseHtml(child, contents);
        }
    }

    private static String getIssueTitle(Issue issue) {
        String title = issue.getType();
        if (StringUtils.isBlank((CharSequence)title) || UNDEFINED_ISSUE_STRING.equals(title)) {
            title = issue.getCategory();
        }
        return title;
    }

    public static enum ChecksAnnotationScope {
        ALL,
        NEW,
        MODIFIED,
        SKIP;


        static ListBoxModel fillItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(Messages.ChecksAnnotationScope_ALL(), ALL.name());
            items.add(Messages.ChecksAnnotationScope_NEW(), NEW.name());
            items.add(Messages.ChecksAnnotationScope_MODIFIED(), MODIFIED.name());
            items.add(Messages.ChecksAnnotationScope_SKIP(), SKIP.name());
            return items;
        }
    }
}

