/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.analysis.core.model.LabelProviderFactory;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.steps.AnalysisExecution;
import io.jenkins.plugins.analysis.core.steps.AnalysisStepDescriptor;
import io.jenkins.plugins.analysis.core.steps.AnnotatedReport;
import io.jenkins.plugins.analysis.core.steps.IssuesPublisher;
import io.jenkins.plugins.analysis.core.steps.Messages;
import io.jenkins.plugins.analysis.core.steps.WarningChecksPublisher;
import io.jenkins.plugins.analysis.core.util.HealthDescriptor;
import io.jenkins.plugins.analysis.core.util.TrendChartType;
import io.jenkins.plugins.analysis.core.util.WarningsQualityGate;
import io.jenkins.plugins.checks.steps.ChecksInfo;
import io.jenkins.plugins.forensics.delta.DeltaCalculator;
import io.jenkins.plugins.forensics.delta.DeltaCalculatorFactory;
import io.jenkins.plugins.util.LogHandler;
import io.jenkins.plugins.util.ResultHandler;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.impl.factory.Sets;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PublishIssuesStep
extends Step
implements Serializable {
    private static final long serialVersionUID = -1833335402353771148L;
    private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();
    private final List<AnnotatedReport> reports;
    private String sourceCodeEncoding = "";
    private boolean ignoreQualityGate;
    private boolean failOnError;
    private boolean skipDeltaCalculation;
    private boolean skipPublishingChecks;
    private WarningChecksPublisher.ChecksAnnotationScope checksAnnotationScope = WarningChecksPublisher.ChecksAnnotationScope.NEW;
    private boolean quiet;
    private int healthy;
    private int unhealthy;
    private Severity minimumSeverity = Severity.WARNING_LOW;
    private List<WarningsQualityGate> qualityGates = new ArrayList<WarningsQualityGate>();
    private TrendChartType trendChartType = TrendChartType.AGGREGATION_TOOLS;
    private String id = "";
    private String name = "";
    private String icon = "";
    private String scm = "";

    @DataBoundConstructor
    public PublishIssuesStep(@CheckForNull List<AnnotatedReport> issues) {
        this.reports = issues == null ? new ArrayList<AnnotatedReport>() : new ArrayList<AnnotatedReport>(issues);
    }

    public List<AnnotatedReport> getIssues() {
        return new ArrayList<AnnotatedReport>(this.reports);
    }

    @DataBoundSetter
    public void setId(String id) {
        VALIDATION_UTILITIES.ensureValidId(id);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    @DataBoundSetter
    public void setScm(String scm) {
        this.scm = scm;
    }

    public String getScm() {
        return this.scm;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public boolean isSkipDeltaCalculation() {
        return this.skipDeltaCalculation;
    }

    @DataBoundSetter
    public void setSkipDeltaCalculation(boolean skipDeltaCalculation) {
        this.skipDeltaCalculation = skipDeltaCalculation;
    }

    public boolean isSkipPublishingChecks() {
        return this.skipPublishingChecks;
    }

    @DataBoundSetter
    public void setSkipPublishingChecks(boolean skipPublishingChecks) {
        this.skipPublishingChecks = skipPublishingChecks;
    }

    @DataBoundSetter
    public void setChecksAnnotationScope(WarningChecksPublisher.ChecksAnnotationScope checksAnnotationScope) {
        this.checksAnnotationScope = checksAnnotationScope;
    }

    public WarningChecksPublisher.ChecksAnnotationScope getChecksAnnotationScope() {
        return this.checksAnnotationScope;
    }

    @Deprecated
    public boolean isPublishAllIssues() {
        return this.getChecksAnnotationScope() == WarningChecksPublisher.ChecksAnnotationScope.ALL;
    }

    @Deprecated
    @DataBoundSetter
    public void setPublishAllIssues(boolean publishAllIssues) {
        this.checksAnnotationScope = publishAllIssues ? WarningChecksPublisher.ChecksAnnotationScope.ALL : WarningChecksPublisher.ChecksAnnotationScope.NEW;
    }

    @DataBoundSetter
    public void setIgnoreQualityGate(boolean ignoreQualityGate) {
        this.ignoreQualityGate = ignoreQualityGate;
    }

    public boolean getIgnoreQualityGate() {
        return this.ignoreQualityGate;
    }

    @DataBoundSetter
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    @CheckForNull
    public String getSourceCodeEncoding() {
        return this.sourceCodeEncoding;
    }

    @DataBoundSetter
    public void setSourceCodeEncoding(String sourceCodeEncoding) {
        this.sourceCodeEncoding = sourceCodeEncoding;
    }

    public int getHealthy() {
        return this.healthy;
    }

    @DataBoundSetter
    public void setHealthy(int healthy) {
        this.healthy = healthy;
    }

    public int getUnhealthy() {
        return this.unhealthy;
    }

    @DataBoundSetter
    public void setUnhealthy(int unhealthy) {
        this.unhealthy = unhealthy;
    }

    @CheckForNull
    public String getMinimumSeverity() {
        return this.minimumSeverity.getName();
    }

    @CheckForNull
    public Severity getMinimumSeverityAsSeverity() {
        return this.minimumSeverity;
    }

    @DataBoundSetter
    public void setMinimumSeverity(String minimumSeverity) {
        this.minimumSeverity = Severity.valueOf((String)minimumSeverity, (Severity)Severity.WARNING_LOW);
    }

    @DataBoundSetter
    public void setTrendChartType(TrendChartType trendChartType) {
        this.trendChartType = trendChartType;
    }

    public TrendChartType getTrendChartType() {
        return this.trendChartType;
    }

    @DataBoundSetter
    public void setQualityGates(List<WarningsQualityGate> qualityGates) {
        this.qualityGates = qualityGates;
    }

    public List<WarningsQualityGate> getQualityGates() {
        return this.qualityGates;
    }

    public StepExecution start(StepContext stepContext) {
        return new Execution(stepContext, this);
    }

    @SuppressFBWarnings(value={"THROWS"}, justification="false positive")
    static class Execution
    extends AnalysisExecution<ResultAction> {
        private static final long serialVersionUID = 6438321240776419897L;
        private final PublishIssuesStep step;

        Execution(@NonNull StepContext context, PublishIssuesStep step) {
            super(context);
            if (step.reports.isEmpty()) {
                throw new IllegalArgumentException("No reports provided in publish issues step, parameter 'issues' must be set!");
            }
            this.step = step;
        }

        protected ResultAction run() throws IOException, InterruptedException, IllegalStateException {
            AnnotatedReport report;
            if (this.step.reports.size() > 1) {
                report = new AnnotatedReport((String)StringUtils.defaultIfEmpty((CharSequence)this.step.getId(), (CharSequence)"analysis"));
                report.logInfo("Aggregating reports of:", new Object[0]);
                LabelProviderFactory factory = new LabelProviderFactory();
                for (AnnotatedReport subReport : this.step.reports) {
                    StaticAnalysisLabelProvider labelProvider = factory.create(subReport.getId());
                    report.logInfo("-> %s", labelProvider.getToolTip(subReport.size()));
                }
            } else {
                report = new AnnotatedReport((String)StringUtils.defaultIfEmpty((CharSequence)this.step.getId(), (CharSequence)this.step.reports.get(0).getId()));
            }
            report.addAll(this.step.reports);
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            DeltaCalculator.NullDeltaCalculator deltaCalculator = workspace == null || this.step.isSkipDeltaCalculation() ? new DeltaCalculator.NullDeltaCalculator() : DeltaCalculatorFactory.findDeltaCalculator((String)this.step.scm, this.getRun(), (FilePath)workspace, (TaskListener)this.getTaskListener(), (FilteredLog)new FilteredLog());
            IssuesPublisher publisher = new IssuesPublisher(this.getRun(), report, (DeltaCalculator)deltaCalculator, new HealthDescriptor(this.step.getHealthy(), this.step.getUnhealthy(), this.step.getMinimumSeverityAsSeverity()), this.step.getQualityGates(), StringUtils.defaultString((String)this.step.getName()), this.step.getIcon(), this.step.getIgnoreQualityGate(), this.getCharset(this.step.getSourceCodeEncoding()), this.getLogger(report), (ResultHandler)this.createResultHandler(), this.step.getFailOnError());
            ResultAction action = publisher.attachAction(this.step.getTrendChartType());
            if (!this.step.isSkipPublishingChecks()) {
                WarningChecksPublisher checksPublisher = new WarningChecksPublisher(action, this.getTaskListener(), (ChecksInfo)this.getContext().get(ChecksInfo.class));
                checksPublisher.publishChecks(this.step.getChecksAnnotationScope());
            }
            return action;
        }

        private LogHandler getLogger(AnnotatedReport annotatedReport) throws InterruptedException {
            String toolName = new LabelProviderFactory().create(annotatedReport.getId(), StringUtils.defaultString((String)this.step.getName())).getName();
            LogHandler logHandler = new LogHandler(this.getTaskListener(), toolName, annotatedReport.getLogger());
            logHandler.setQuiet(this.step.isQuiet());
            Report report = annotatedReport.getReport();
            logHandler.logInfoMessages(report.getInfoMessages());
            logHandler.logErrorMessages(report.getErrorMessages());
            return logHandler;
        }
    }

    @Extension
    public static class Descriptor
    extends AnalysisStepDescriptor {
        public Set<Class<?>> getRequiredContext() {
            return Sets.immutable.of(FlowNode.class, Run.class, TaskListener.class).castToSet();
        }

        public String getFunctionName() {
            return "publishIssues";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.PublishIssues_DisplayName();
        }
    }
}

