/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssuesInModifiedCodeMarker;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.FilteredLog;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.AggregationAction;
import io.jenkins.plugins.analysis.core.model.AnalysisHistory;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.ByIdResultSelector;
import io.jenkins.plugins.analysis.core.model.DeltaReport;
import io.jenkins.plugins.analysis.core.model.QualityGateEvaluationMode;
import io.jenkins.plugins.analysis.core.model.ResetReferenceAction;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.model.ResultSelector;
import io.jenkins.plugins.analysis.core.steps.AnnotatedReport;
import io.jenkins.plugins.analysis.core.util.HealthDescriptor;
import io.jenkins.plugins.analysis.core.util.TrendChartType;
import io.jenkins.plugins.analysis.core.util.WarningsQualityGate;
import io.jenkins.plugins.analysis.core.util.WarningsQualityGateEvaluator;
import io.jenkins.plugins.forensics.delta.Delta;
import io.jenkins.plugins.forensics.delta.DeltaCalculator;
import io.jenkins.plugins.forensics.delta.FileChanges;
import io.jenkins.plugins.forensics.reference.ReferenceBuild;
import io.jenkins.plugins.forensics.reference.ReferenceFinder;
import io.jenkins.plugins.util.LogHandler;
import io.jenkins.plugins.util.QualityGateResult;
import io.jenkins.plugins.util.ResultHandler;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class IssuesPublisher {
    private final AnnotatedReport report;
    private final Run<?, ?> run;
    private final DeltaCalculator deltaCalculator;
    private final HealthDescriptor healthDescriptor;
    private final String name;
    private final String icon;
    private final Charset sourceCodeEncoding;
    private final List<WarningsQualityGate> qualityGates;
    private final QualityGateEvaluationMode qualityGateEvaluationMode;
    private final LogHandler logger;
    private final ResultHandler notifier;
    private final boolean failOnErrors;

    IssuesPublisher(Run<?, ?> run, AnnotatedReport report, DeltaCalculator deltaCalculator, HealthDescriptor healthDescriptor, List<WarningsQualityGate> qualityGates, String name, String icon, boolean ignoreQualityGate, Charset sourceCodeEncoding, LogHandler logger, ResultHandler notifier, boolean failOnErrors) {
        this.report = report;
        this.run = run;
        this.deltaCalculator = deltaCalculator;
        this.healthDescriptor = healthDescriptor;
        this.name = name;
        this.icon = icon;
        this.sourceCodeEncoding = sourceCodeEncoding;
        this.qualityGates = qualityGates;
        this.qualityGateEvaluationMode = ignoreQualityGate ? QualityGateEvaluationMode.IGNORE_QUALITY_GATE : QualityGateEvaluationMode.SUCCESSFUL_QUALITY_GATE;
        this.logger = logger;
        this.notifier = notifier;
        this.failOnErrors = failOnErrors;
    }

    private String getId() {
        return this.report.getId();
    }

    ResultAction attachAction(TrendChartType trendChartType) {
        AggregationAction action;
        Report issues = this.report.getReport();
        DeltaReport deltaReport = this.computeDelta(issues);
        QualityGateResult qualityGateResult = this.evaluateQualityGate(issues, deltaReport);
        this.reportHealth(issues);
        issues.logInfo("Created analysis result for %d issues (found %d new issues, fixed %d issues)", new Object[]{deltaReport.getAllIssues().size(), deltaReport.getNewIssues().size(), deltaReport.getFixedIssues().size()});
        if (this.failOnErrors && issues.hasErrors()) {
            issues.logInfo("Failing build because analysis result contains errors", new Object[0]);
            this.run.setResult(Result.FAILURE);
        }
        if (trendChartType == TrendChartType.AGGREGATION_TOOLS && (action = (AggregationAction)this.run.getAction(AggregationAction.class)) == null) {
            this.run.addAction((Action)new AggregationAction());
        }
        issues.logInfo("Attaching ResultAction with ID '%s' to build '%s'.", new Object[]{this.getId(), this.run});
        this.logger.logInfoMessages(issues.getInfoMessages());
        this.logger.logErrorMessages(issues.getErrorMessages());
        AnalysisResult result = new AnalysisHistory(this.run, this.ensureThatIdIsUnique()).getResult().map(previous -> new AnalysisResult(this.run, this.getId(), deltaReport, this.report.getBlames(), this.report.getStatistics(), qualityGateResult, this.report.getSizeOfOrigin(), (AnalysisResult)previous)).orElseGet(() -> new AnalysisResult(this.run, this.getId(), deltaReport, this.report.getBlames(), this.report.getStatistics(), qualityGateResult, this.report.getSizeOfOrigin()));
        ResultAction action2 = new ResultAction(this.run, result, this.healthDescriptor, this.getId(), this.name, this.icon, this.sourceCodeEncoding, trendChartType);
        this.run.addAction((Action)action2);
        if (trendChartType == TrendChartType.TOOLS_AGGREGATION || trendChartType == TrendChartType.AGGREGATION_ONLY) {
            this.run.addOrReplaceAction((Action)new AggregationAction());
        }
        return action2;
    }

    private long count(Report issues) {
        return issues.stream().filter(Issue::isPartOfModifiedCode).count();
    }

    private DeltaReport computeDelta(Report issues) {
        ResultSelector selector = this.ensureThatIdIsUnique();
        Optional<Run<?, ?>> possibleReferenceBuild = this.findReferenceBuild(selector, issues);
        if (possibleReferenceBuild.isPresent()) {
            Run<?, ?> build = possibleReferenceBuild.get();
            ResultAction resultAction = selector.get(build).orElseThrow(() -> new IllegalStateException("Reference build does not contain a result action"));
            DeltaReport deltaReport = new DeltaReport(issues, build, this.run.getNumber(), resultAction.getResult().getIssues());
            this.markIssuesInModifiedFiles(build, issues, deltaReport);
            return deltaReport;
        }
        return new DeltaReport(issues, this.run.getNumber());
    }

    private void markIssuesInModifiedFiles(Run<?, ?> referenceBuild, Report issues, DeltaReport deltaReport) {
        if (issues.isNotEmpty()) {
            this.report.logInfo("Detect all issues that are part of modified code", new Object[0]);
            FilteredLog log = new FilteredLog("Errors while computing delta: ");
            Optional delta = this.deltaCalculator.calculateDelta(this.run, referenceBuild, log);
            issues.mergeLogMessages(log);
            if (delta.isPresent()) {
                Map<String, Set> changes = ((Delta)delta.get()).getFileChangesMap().values().stream().collect(Collectors.toMap(FileChanges::getFileName, FileChanges::getModifiedLines, (left, right) -> {
                    left.addAll(right);
                    return left;
                }));
                IssuesInModifiedCodeMarker marker = new IssuesInModifiedCodeMarker();
                marker.markIssuesInModifiedCode(issues, changes);
                this.report.logInfo("Issues in modified code: %d (new: %d, outstanding: %d)", this.count(deltaReport.getAllIssues()), this.count(deltaReport.getNewIssues()), this.count(deltaReport.getOutstandingIssues()));
            } else {
                this.report.logInfo("No relevant modified code found", new Object[0]);
            }
        } else {
            this.report.logInfo("Skip detection of issues in modified code", new Object[0]);
        }
    }

    private ResultSelector ensureThatIdIsUnique() {
        ByIdResultSelector selector = new ByIdResultSelector(this.getId());
        Optional<ResultAction> other = selector.get(this.run);
        if (other.isPresent()) {
            throw new IllegalStateException("ID %s is already used by another action: %s%n".formatted(this.getId(), other.get()));
        }
        return selector;
    }

    private void reportHealth(Report filtered) {
        if (this.healthDescriptor.isEnabled()) {
            if (this.healthDescriptor.isValid()) {
                filtered.logInfo("Enabling health report (%s)", new Object[]{this.healthDescriptor});
            } else {
                filtered.logInfo("Health report is invalid (%s) - skipping", new Object[]{this.healthDescriptor});
            }
        } else {
            filtered.logInfo("Health report is disabled - skipping", new Object[0]);
        }
    }

    private QualityGateResult evaluateQualityGate(Report issues, DeltaReport deltaReport) {
        WarningsQualityGateEvaluator evaluator = new WarningsQualityGateEvaluator(this.qualityGates, deltaReport.getStatistics());
        FilteredLog log = new FilteredLog("Errors while evaluating quality gates:");
        QualityGateResult qualityGateStatus = evaluator.evaluate(this.notifier, log);
        issues.mergeLogMessages(log);
        return qualityGateStatus;
    }

    private Optional<Run<?, ?>> findReferenceBuild(ResultSelector selector, Report issues) {
        FilteredLog log = new FilteredLog("Errors while resolving the reference build:");
        Optional reference = new ReferenceFinder().findReference(this.run, log);
        issues.mergeLogMessages(log);
        if (reference.isPresent()) {
            return this.refineReferenceBasedOnQualityGate(selector, issues, (Run)reference.get());
        }
        return Optional.empty();
    }

    private Optional<Run<?, ?>> refineReferenceBasedOnQualityGate(ResultSelector selector, Report issues, Run<?, ?> reference) {
        boolean isSkipped = false;
        QualityGateEvaluationMode gateEvaluationMode = this.determineQualityGateEvaluationMode(issues);
        for (Run r = reference; r != null; r = r.getPreviousBuild()) {
            Result result = r.getResult();
            if (result == null || !result.isBetterOrEqualTo(this.getRequiredResult())) continue;
            String displayName = r.getFullDisplayName();
            Optional<ResultAction> action = selector.get(r);
            if (action.isPresent()) {
                ResultAction resultAction = action.get();
                if (resultAction.isSuccessful()) {
                    issues.logInfo("Quality gate successful for reference build '%s', using this build as reference", new Object[]{displayName});
                    return Optional.of(r);
                }
                if (gateEvaluationMode == QualityGateEvaluationMode.IGNORE_QUALITY_GATE) {
                    issues.logInfo("Quality gate has been missed for reference build '%s', but is configured to be ignored", new Object[]{displayName});
                    return Optional.of(r);
                }
                if (isSkipped) continue;
                issues.logInfo("Quality gate failed for reference build '%s', analyzing previous builds", new Object[]{displayName});
                isSkipped = true;
                continue;
            }
            if (isSkipped) continue;
            issues.logInfo("Reference build '%s' does not contain a result action, analyzing previous builds", new Object[]{displayName});
            isSkipped = true;
        }
        issues.logInfo("No reference build with successful quality gate found, skipping delta computation", new Object[0]);
        return Optional.empty();
    }

    private Result getRequiredResult() {
        ReferenceBuild action = (ReferenceBuild)this.run.getAction(ReferenceBuild.class);
        if (action == null) {
            return Result.UNSTABLE;
        }
        return action.getRequiredResult();
    }

    private QualityGateEvaluationMode determineQualityGateEvaluationMode(Report filtered) {
        Run previous = this.run.getPreviousCompletedBuild();
        if (previous != null) {
            List actions = previous.getActions(ResetReferenceAction.class);
            for (ResetReferenceAction action : actions) {
                if (!this.report.getId().equals(action.getId())) continue;
                filtered.logInfo("Resetting reference build, ignoring quality gate result for one build", new Object[0]);
                return QualityGateEvaluationMode.IGNORE_QUALITY_GATE;
            }
        }
        return this.qualityGateEvaluationMode;
    }
}

