/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.VisibleForTesting;
import io.jenkins.plugins.analysis.core.model.DescriptionProvider;
import io.jenkins.plugins.analysis.core.model.DetailsTableModel;
import io.jenkins.plugins.analysis.core.model.FileNameRenderer;
import io.jenkins.plugins.analysis.core.model.Messages;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.forensics.miner.FileStatistics;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.ArrayList;
import java.util.List;

public class ForensicsModel
extends DetailsTableModel {
    static final String UNDEFINED = "-";
    private final RepositoryStatistics statistics;

    ForensicsModel(Report report, RepositoryStatistics statistics, FileNameRenderer fileNameRenderer, StaticAnalysisLabelProvider.AgeBuilder ageBuilder, DescriptionProvider labelProvider) {
        this(report, statistics, fileNameRenderer, ageBuilder, labelProvider, new JenkinsFacade());
    }

    @VisibleForTesting
    ForensicsModel(Report report, RepositoryStatistics statistics, FileNameRenderer fileNameRenderer, StaticAnalysisLabelProvider.AgeBuilder ageBuilder, DescriptionProvider labelProvider, JenkinsFacade jenkinsFacade) {
        super(report, fileNameRenderer, ageBuilder, labelProvider, jenkinsFacade);
        this.statistics = statistics;
    }

    public String getId() {
        return "forensics";
    }

    public List<TableColumn> getColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        columns.add(this.createDetailsColumn());
        columns.add(this.createFileColumn());
        columns.add(this.createAgeColumn());
        TableColumn authorsSize = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_AuthorsSize()).withDataPropertyKey("authorsSize").withResponsivePriority(1).withType(TableColumn.ColumnType.NUMBER).build();
        columns.add(authorsSize);
        TableColumn commitsSize = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_CommitsSize()).withDataPropertyKey("commitsSize").withResponsivePriority(1).withType(TableColumn.ColumnType.NUMBER).build();
        columns.add(commitsSize);
        TableColumn modifiedAt = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_LastCommit()).withDataPropertyKey("modifiedAt").withResponsivePriority(50).withHeaderClass(TableColumn.ColumnCss.DATE).build();
        columns.add(modifiedAt);
        TableColumn addedAt = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_AddedAt()).withDataPropertyKey("addedAt").withResponsivePriority(50).withHeaderClass(TableColumn.ColumnCss.DATE).build();
        columns.add(addedAt);
        TableColumn linesOfCode = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_LOC()).withDataPropertyKey("linesOfCode").withResponsivePriority(25).withType(TableColumn.ColumnType.NUMBER).build();
        columns.add(linesOfCode);
        TableColumn churn = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Table_Column_Churn()).withDataPropertyKey("churn").withResponsivePriority(25).withType(TableColumn.ColumnType.NUMBER).build();
        columns.add(churn);
        columns.add(this.createHiddenDetailsColumn());
        return columns;
    }

    @Override
    public ForensicsRow getRow(Issue issue) {
        ForensicsRow row = new ForensicsRow(this.getAgeBuilder(), this.getFileNameRenderer(), this.getDescriptionProvider(), issue, this.getJenkinsFacade());
        if (this.statistics.contains(issue.getFileName())) {
            FileStatistics result = this.statistics.get(issue.getFileName());
            row.setAuthorsSize(String.valueOf(result.getNumberOfAuthors()));
            row.setCommitsSize(String.valueOf(result.getNumberOfCommits()));
            row.setModifiedAt(result.getLastModificationTime());
            row.setAddedAt(result.getCreationTime());
            row.setLinesOfCode(result.getLinesOfCode());
            row.setChurn(result.getAbsoluteChurn());
        } else {
            row.setAuthorsSize(UNDEFINED);
            row.setCommitsSize(UNDEFINED);
            row.setModifiedAt(0);
            row.setAddedAt(0);
            row.setLinesOfCode(0);
            row.setChurn(0);
        }
        return row;
    }

    public static class ForensicsRow
    extends DetailsTableModel.TableRow {
        private String authorsSize;
        private String commitsSize;
        private int modifiedAt;
        private int addedAt;
        private int linesOfCode;
        private int churn;

        ForensicsRow(StaticAnalysisLabelProvider.AgeBuilder ageBuilder, FileNameRenderer fileNameRenderer, DescriptionProvider descriptionProvider, Issue issue, JenkinsFacade jenkinsFacade) {
            super(ageBuilder, fileNameRenderer, descriptionProvider, issue, jenkinsFacade);
        }

        public String getAuthorsSize() {
            return this.authorsSize;
        }

        public String getCommitsSize() {
            return this.commitsSize;
        }

        public int getModifiedAt() {
            return this.modifiedAt;
        }

        public int getAddedAt() {
            return this.addedAt;
        }

        void setAuthorsSize(String authorsSize) {
            this.authorsSize = authorsSize;
        }

        void setCommitsSize(String commitsSize) {
            this.commitsSize = commitsSize;
        }

        void setModifiedAt(int modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        void setAddedAt(int addedAt) {
            this.addedAt = addedAt;
        }

        public int getLinesOfCode() {
            return this.linesOfCode;
        }

        public void setLinesOfCode(int linesOfCode) {
            this.linesOfCode = linesOfCode;
        }

        public int getChurn() {
            return this.churn;
        }

        public void setChurn(int churn) {
            this.churn = churn;
        }
    }
}

