/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings;

import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.registry.ParserDescriptor;
import edu.hm.hafner.analysis.registry.ParserRegistry;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.analysis.core.model.ReportScanningTool;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.warnings.Messages;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.verb.POST;

public class RegisteredParser
extends ReportScanningTool {
    private static final long serialVersionUID = 22286587552212078L;
    private static final ParserRegistry REGISTRY = new ParserRegistry();
    private final String analysisModelId;

    @DataBoundConstructor
    public RegisteredParser(String analysisModelId) {
        this.analysisModelId = analysisModelId;
        if (!REGISTRY.contains(analysisModelId)) {
            throw new NoSuchElementException("No such parser found with the specified ID: " + analysisModelId);
        }
    }

    public String getAnalysisModelId() {
        return this.analysisModelId;
    }

    private ParserDescriptor getParserDescriptor() {
        return REGISTRY.get(this.analysisModelId);
    }

    @Override
    public String getId() {
        return (String)StringUtils.defaultIfBlank((CharSequence)super.getId(), (CharSequence)this.getParserDescriptor().getId());
    }

    @Override
    public String getName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)super.getName(), (CharSequence)this.getParserDescriptor().getName());
    }

    @Override
    public IssueParser createParser() {
        return this.getParserDescriptor().createParser(new ParserDescriptor.Option[0]);
    }

    @Override
    public StaticAnalysisLabelProvider getLabelProvider() {
        ParserDescriptor descriptor = this.getParserDescriptor();
        return new StaticAnalysisLabelProvider(descriptor.getId(), this.getName(), arg_0 -> ((ParserDescriptor)descriptor).getDescription(arg_0), descriptor.getType());
    }

    @Override
    public String getActualPattern() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getPattern(), (CharSequence)this.getParserDescriptor().getPattern());
    }

    @Symbol(value={"analysisParser"})
    @Extension
    public static class Descriptor
    extends ReportScanningTool.ReportScanningToolDescriptor {
        @VisibleForTesting
        static final String ANALYSIS_MODEL_ID = "analysis-model";
        private static final ListBoxModel EMPTY_MODEL = new ListBoxModel();
        private final ListBoxModel availableParsers = new ListBoxModel();
        private final JenkinsFacade jenkinsFacade;

        public Descriptor() {
            this(new JenkinsFacade());
        }

        @VisibleForTesting
        Descriptor(JenkinsFacade jenkinsFacade) {
            super(ANALYSIS_MODEL_ID);
            List allDescriptors = new ParserRegistry().getAllDescriptors();
            allDescriptors.sort(Comparator.comparing(ParserDescriptor::getName));
            allDescriptors.stream().map(d -> new ListBoxModel.Option(d.getName(), d.getId())).forEach(arg_0 -> this.availableParsers.add(arg_0));
            this.jenkinsFacade = jenkinsFacade;
        }

        @POST
        public ListBoxModel doFillAnalysisModelIdItems() {
            if (this.jenkinsFacade.hasPermission(Jenkins.READ)) {
                return this.availableParsers;
            }
            return EMPTY_MODEL;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.RegisteredParser_Name();
        }
    }
}

