/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.steps;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.FileNameResolver;
import edu.hm.hafner.analysis.FingerprintGenerator;
import edu.hm.hafner.analysis.FullTextFingerprint;
import edu.hm.hafner.analysis.ModuleDetectorRunner;
import edu.hm.hafner.analysis.ModuleResolver;
import edu.hm.hafner.analysis.PackageNameResolver;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.FilteredLog;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.analysis.core.filter.RegexpFilter;
import io.jenkins.plugins.analysis.core.model.ReportLocations;
import io.jenkins.plugins.analysis.core.model.ReportScanningTool;
import io.jenkins.plugins.analysis.core.model.Tool;
import io.jenkins.plugins.analysis.core.steps.AnnotatedReport;
import io.jenkins.plugins.analysis.core.util.AffectedFilesResolver;
import io.jenkins.plugins.analysis.core.util.ConsoleLogHandler;
import io.jenkins.plugins.analysis.core.util.FileFinder;
import io.jenkins.plugins.forensics.blame.Blamer;
import io.jenkins.plugins.forensics.blame.BlamerFactory;
import io.jenkins.plugins.forensics.blame.Blames;
import io.jenkins.plugins.forensics.blame.FileLocations;
import io.jenkins.plugins.forensics.miner.MinerService;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import io.jenkins.plugins.prism.PermittedSourceCodeDirectory;
import io.jenkins.plugins.prism.PrismConfiguration;
import io.jenkins.plugins.prism.SourceCodeRetention;
import io.jenkins.plugins.prism.SourceDirectoryFilter;
import io.jenkins.plugins.util.LogHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;

class IssuesScanner {
    private final FilePath workspace;
    private final Set<String> sourceDirectories;
    private final SourceCodeRetention sourceCodeRetention;
    private final Run<?, ?> run;
    private final FilePath jenkinsRootDir;
    private final Charset sourceCodeEncoding;
    private final Tool tool;
    private final List<RegexpFilter> filters;
    private final TaskListener listener;
    private final String scm;
    private final BlameMode blameMode;
    private final PostProcessingMode postProcessingMode;
    private final boolean quiet;

    IssuesScanner(Tool tool, List<RegexpFilter> filters, Charset sourceCodeEncoding, FilePath workspace, Set<String> sourceDirectories, SourceCodeRetention sourceCodeRetention, Run<?, ?> run, FilePath jenkinsRootDir, TaskListener listener, String scm, BlameMode blameMode, PostProcessingMode postProcessingMode, boolean quiet) {
        this.filters = new ArrayList<RegexpFilter>(filters);
        this.sourceCodeEncoding = sourceCodeEncoding;
        this.tool = tool;
        this.workspace = workspace;
        this.sourceDirectories = sourceDirectories;
        this.sourceCodeRetention = sourceCodeRetention;
        this.run = run;
        this.jenkinsRootDir = jenkinsRootDir;
        this.listener = listener;
        this.scm = scm;
        this.blameMode = blameMode;
        this.postProcessingMode = postProcessingMode;
        this.quiet = quiet;
    }

    public AnnotatedReport scan() throws IOException, InterruptedException {
        LogHandler logger = new LogHandler(this.listener, this.tool.getActualName());
        logger.setQuiet(this.quiet);
        Report report = this.tool.scan(this.run, this.workspace, this.sourceCodeEncoding, logger);
        AnnotatedReport annotatedReport = this.postProcessReport(report);
        RepositoryStatistics statistics = this.getRepositoryStatistics(annotatedReport.getReport());
        annotatedReport.addRepositoryStatistics(statistics);
        logger.logInfoMessages(annotatedReport.getReport().getInfoMessages());
        logger.logErrorMessages(annotatedReport.getReport().getErrorMessages());
        return annotatedReport;
    }

    private RepositoryStatistics getRepositoryStatistics(Report report) {
        MinerService minerService = new MinerService();
        FilteredLog log = new FilteredLog("Errors while obtaining repository statistics");
        RepositoryStatistics statistics = minerService.queryStatisticsFor(this.scm, this.run, report.getFiles(), log);
        report.mergeLogMessages(log);
        return statistics;
    }

    private AnnotatedReport postProcessReport(Report report) throws IOException, InterruptedException {
        if (this.tool.getDescriptor().isPostProcessingEnabled() && report.isNotEmpty()) {
            report.logInfo("Post processing issues on '%s' with source code encoding '%s'", new Object[]{this.getAgentName(), this.sourceCodeEncoding});
            AnnotatedReport result = (AnnotatedReport)this.workspace.act((FilePath.FileCallable)this.createPostProcessor(report));
            this.copyAffectedFiles(result.getReport(), this.createAffectedFilesFolder(result.getReport()));
            return result;
        }
        report.logInfo("Skipping post processing", new Object[0]);
        return new AnnotatedReport(this.tool.getActualId(), IssuesScanner.filter(report, this.filters));
    }

    private ReportPostProcessor createPostProcessor(Report report) {
        int linesLookAhead = -1;
        Tool tool = this.tool;
        if (tool instanceof ReportScanningTool) {
            ReportScanningTool scanningTool = (ReportScanningTool)tool;
            linesLookAhead = scanningTool.getLinesLookAhead();
        }
        return new ReportPostProcessor(this.tool.getActualId(), report, this.sourceCodeEncoding.name(), this.createBlamer(report), this.filters, this.getPermittedSourceDirectories(), this.sourceDirectories, this.postProcessingMode, linesLookAhead);
    }

    private Set<String> getPermittedSourceDirectories() {
        return PrismConfiguration.getInstance().getSourceDirectories().stream().map(PermittedSourceCodeDirectory::getPath).collect(Collectors.toSet());
    }

    private Blamer createBlamer(Report report) {
        if (this.blameMode == BlameMode.DISABLED) {
            report.logInfo("Skipping SCM blames as requested", new Object[0]);
            return new Blamer.NullBlamer();
        }
        FilteredLog log = new FilteredLog("Errors while determining a supported blamer for " + this.run.getFullDisplayName());
        report.logInfo("Creating SCM blamer to obtain author and commit information for affected files", new Object[0]);
        if (!StringUtils.isBlank((CharSequence)this.scm)) {
            report.logInfo("-> Filtering SCMs by key '%s'", new Object[]{this.scm});
        }
        Blamer blamer = BlamerFactory.findBlamer((String)this.scm, this.run, (FilePath)this.workspace, (TaskListener)this.listener, (FilteredLog)log);
        report.mergeLogMessages(log);
        return blamer;
    }

    private void copyAffectedFiles(Report report, FilePath buildFolder) throws InterruptedException {
        FilteredLog log = new FilteredLog("Errors while processing affected files");
        if (this.sourceCodeRetention == SourceCodeRetention.NEVER) {
            report.logInfo("Skipping copying of affected files", new Object[0]);
        } else {
            report.logInfo("Copying affected files to Jenkins' build folder '%s'", new Object[]{buildFolder});
            Set<String> permittedSourceDirectories = this.getPermittedSourceDirectories();
            permittedSourceDirectories.add(this.workspace.getRemote());
            new AffectedFilesResolver().copyAffectedFilesToBuildFolder(report, this.workspace, permittedSourceDirectories, buildFolder);
        }
        this.sourceCodeRetention.cleanup(this.run, "files-with-issues", log);
        report.mergeLogMessages(log);
    }

    private FilePath createAffectedFilesFolder(Report report) throws InterruptedException {
        FilePath buildDirectory = this.jenkinsRootDir.child("files-with-issues");
        try {
            buildDirectory.mkdirs();
        }
        catch (IOException exception) {
            report.logException((Exception)exception, "Can't create directory '%s' for affected workspace files.", new Object[]{buildDirectory});
        }
        return buildDirectory;
    }

    private String getAgentName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getComputerName(), (CharSequence)"Master");
    }

    private String getComputerName() {
        Computer computer = this.workspace.toComputer();
        if (computer != null) {
            return computer.getName();
        }
        return "";
    }

    private static Report filter(Report report, List<RegexpFilter> filters) {
        int actualFilterSize = 0;
        Report.IssueFilterBuilder builder = new Report.IssueFilterBuilder();
        for (RegexpFilter filter : filters) {
            if (!StringUtils.isNotBlank((CharSequence)filter.getPattern())) continue;
            filter.apply(builder);
            ++actualFilterSize;
        }
        Report filtered = report.filter(builder.build());
        if (actualFilterSize > 0) {
            filtered.logInfo("Applying %d filters on the set of %d issues (%d issues have been removed, %d issues will be published)", new Object[]{filters.size(), report.size(), report.size() - filtered.size(), filtered.size()});
        } else {
            filtered.logInfo("No filter has been set, publishing all %d issues", new Object[]{filtered.size()});
        }
        return filtered;
    }

    static enum BlameMode {
        ENABLED,
        DISABLED;

    }

    static enum PostProcessingMode {
        ENABLED,
        DISABLED;

    }

    private static class ReportPostProcessor
    extends MasterToSlaveFileCallable<AnnotatedReport> {
        private static final long serialVersionUID = -9138045560271783096L;
        private static final String SKIPPING_POST_PROCESSING = "Skipping detection of missing package and module names";
        private final String id;
        private final Report originalReport;
        private final String sourceCodeEncoding;
        private final Blamer blamer;
        private final Set<String> permittedSourceDirectories;
        private final Set<String> requestedSourceDirectories;
        private final PostProcessingMode postProcessingMode;
        private final List<RegexpFilter> filters;
        private final int linesLookAhead;

        ReportPostProcessor(String id, Report report, String sourceCodeEncoding, Blamer blamer, List<RegexpFilter> filters, Set<String> permittedSourceDirectories, Set<String> requestedSourceDirectories, PostProcessingMode postProcessingMode, int linesLookAhead) {
            this.id = id;
            this.originalReport = report;
            this.sourceCodeEncoding = sourceCodeEncoding;
            this.blamer = blamer;
            this.filters = filters;
            this.permittedSourceDirectories = permittedSourceDirectories;
            this.requestedSourceDirectories = requestedSourceDirectories;
            this.postProcessingMode = postProcessingMode;
            this.linesLookAhead = linesLookAhead;
        }

        public AnnotatedReport invoke(File workspace, VirtualChannel channel) {
            this.resolvePaths(workspace, this.originalReport);
            if (this.postProcessingMode == PostProcessingMode.ENABLED) {
                this.resolveModuleNames(this.originalReport, workspace);
                this.resolvePackageNames(this.originalReport);
            } else {
                this.originalReport.logInfo(SKIPPING_POST_PROCESSING, new Object[0]);
            }
            Report filtered = IssuesScanner.filter(this.originalReport, this.filters);
            this.createFingerprints(filtered);
            FileLocations fileLocations = new ReportLocations().toFileLocations(filtered);
            return new AnnotatedReport(this.id, filtered, this.blame(filtered, fileLocations));
        }

        private Blames blame(Report filtered, FileLocations fileLocations) {
            if (fileLocations.isEmpty()) {
                return new Blames();
            }
            FilteredLog log = new FilteredLog("Errors while extracting author and commit information from Git:");
            Blames blames = this.blamer.blame(fileLocations, log);
            filtered.mergeLogMessages(log);
            return blames;
        }

        private void resolvePaths(File workspace, Report report) {
            try {
                FileNameResolver nameResolver = new FileNameResolver();
                report.logInfo("Resolving file names for all issues in workspace '%s'", new Object[]{workspace});
                nameResolver.run(report, workspace.getAbsolutePath(), ConsoleLogHandler::isInConsoleLog);
                FilteredLog errors = new FilteredLog("Source-Directories");
                Set<String> filteredSourceDirectories = this.filterSourceDirectories(workspace, errors);
                errors.getErrorMessages().forEach(x$0 -> report.logError(x$0, new Object[0]));
                for (String sourceDirectory : filteredSourceDirectories) {
                    report.logInfo("Resolving file names for all issues in source directory '%s'", new Object[]{sourceDirectory});
                    nameResolver.run(report, sourceDirectory, ConsoleLogHandler::isInConsoleLog);
                }
            }
            catch (InvalidPathException exception) {
                report.logException((Exception)exception, "Resolving of file names aborted", new Object[0]);
            }
        }

        private Set<String> filterSourceDirectories(File workspace, FilteredLog errors) {
            SourceDirectoryFilter filter = new SourceDirectoryFilter();
            return filter.getPermittedSourceDirectories(workspace.getAbsolutePath(), this.permittedSourceDirectories, this.requestedSourceDirectories, errors);
        }

        private void resolveModuleNames(Report report, File workspace) {
            report.logInfo("Resolving module names from module definitions (build.xml, pom.xml, or Manifest.mf files)", new Object[0]);
            try {
                ModuleDetectorRunner runner = new ModuleDetectorRunner(workspace.toPath(), (ModuleDetectorRunner.FileSystemFacade)new DefaultFileSystem());
                ModuleResolver resolver = new ModuleResolver(runner);
                resolver.run(report);
            }
            catch (InvalidPathException exception) {
                report.logException((Exception)exception, "Resolving of modul names aborted", new Object[0]);
            }
        }

        private void resolvePackageNames(Report report) {
            report.logInfo("Resolving package names (or namespaces) by parsing the affected files", new Object[0]);
            try {
                PackageNameResolver resolver = new PackageNameResolver();
                resolver.run(report, this.getCharset());
            }
            catch (InvalidPathException exception) {
                report.logException((Exception)exception, "Resolving of package names aborted", new Object[0]);
            }
        }

        private Charset getCharset() {
            return Charset.forName(this.sourceCodeEncoding);
        }

        private void createFingerprints(Report report) {
            report.logInfo("Creating fingerprints for all affected code blocks to track issues over different builds", new Object[0]);
            FingerprintGenerator generator = new FingerprintGenerator();
            if (this.linesLookAhead < 0) {
                generator.run(new FullTextFingerprint(), report, this.getCharset());
            } else {
                generator.run(new FullTextFingerprint(this.linesLookAhead), report, this.getCharset());
            }
        }
    }

    private static final class DefaultFileSystem
    implements ModuleDetectorRunner.FileSystemFacade {
        private DefaultFileSystem() {
        }

        @MustBeClosed
        public InputStream open(String fileName) throws IOException {
            return Files.newInputStream(Path.of(fileName, new String[0]), new OpenOption[0]);
        }

        public List<String> find(Path root, String pattern) {
            return Arrays.stream(new FileFinder(pattern).find(root.toFile())).toList();
        }
    }
}

