/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.portlets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.Palette;
import edu.hm.hafner.echarts.PieChartModel;
import edu.hm.hafner.echarts.PieData;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.portlets.Messages;
import io.jenkins.plugins.monitoring.MonitorPortlet;
import io.jenkins.plugins.monitoring.MonitorPortletFactory;
import io.jenkins.plugins.util.QualityGateStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class PullRequestMonitoringPortlet
extends MonitorPortlet {
    private final ResultAction action;
    private final AnalysisResult result;

    public PullRequestMonitoringPortlet(ResultAction action) {
        this.action = action;
        this.result = action.getResult();
    }

    public String getTitle() {
        return this.action.getLabelProvider().getName();
    }

    @JavaScriptMethod
    public String getId() {
        return "warnings-ng-" + this.result.getId();
    }

    public boolean isDefault() {
        return true;
    }

    public int getPreferredWidth() {
        return 350;
    }

    public int getPreferredHeight() {
        return 350;
    }

    public Optional<String> getIconUrl() {
        return Optional.ofNullable(this.action.getIconFileName());
    }

    public Optional<String> getDetailViewUrl() {
        return Optional.ofNullable(this.action.getUrlName());
    }

    public String getWarningsModel() {
        JsonObject sunburstData = new JsonObject();
        sunburstData.addProperty("fixed", (Number)this.result.getFixedIssues().getSize());
        sunburstData.addProperty("outstanding", (Number)this.result.getOutstandingIssues().getSize());
        JsonObject newIssues = new JsonObject();
        newIssues.addProperty("total", (Number)this.result.getNewIssues().getSize());
        newIssues.addProperty("low", (Number)this.result.getNewIssues().getSizeOf(Severity.WARNING_LOW));
        newIssues.addProperty("normal", (Number)this.result.getNewIssues().getSizeOf(Severity.WARNING_NORMAL));
        newIssues.addProperty("high", (Number)this.result.getNewIssues().getSizeOf(Severity.WARNING_HIGH));
        newIssues.addProperty("error", (Number)this.result.getNewIssues().getSizeOf(Severity.ERROR));
        sunburstData.add("new", (JsonElement)newIssues);
        return sunburstData.toString();
    }

    public String getNoNewWarningsModel() {
        PieChartModel model = new PieChartModel();
        model.add(new PieData("outstanding", this.result.getOutstandingIssues().getSize()), Palette.YELLOW);
        model.add(new PieData("fixed", this.result.getFixedIssues().getSize()), Palette.GREEN);
        return new JacksonFacade().toJson((Object)model);
    }

    public boolean isEmpty() {
        return this.result.isEmpty();
    }

    public boolean hasNoNewWarnings() {
        return this.result.hasNoNewWarnings();
    }

    public boolean hasQualityGate() {
        return !this.result.getQualityGateStatus().equals((Object)QualityGateStatus.INACTIVE);
    }

    public String getQualityGateResultClass() {
        return this.result.getQualityGateStatus().getIconClass();
    }

    public String getQualityGateResultDescription() {
        return this.result.getQualityGateStatus().getResult().color.getDescription();
    }

    @Extension(optional=true)
    public static class PortletFactory
    extends MonitorPortletFactory {
        public Collection<MonitorPortlet> getPortlets(Run<?, ?> build) {
            List actions = build.getActions(ResultAction.class);
            return actions.stream().map(PullRequestMonitoringPortlet::new).collect(Collectors.toCollection(ArrayList::new));
        }

        public String getDisplayName() {
            return Messages.PullRequestMonitoringPortlet_Name();
        }
    }
}

