/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.model.Tool;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.List;
import java.util.Optional;

public class LabelProviderFactory {
    private final JenkinsFacade jenkins;

    public LabelProviderFactory() {
        this(new JenkinsFacade());
    }

    @VisibleForTesting
    LabelProviderFactory(JenkinsFacade jenkins) {
        this.jenkins = jenkins;
    }

    public StaticAnalysisLabelProvider create(String id) {
        return this.create(id, "");
    }

    public StaticAnalysisLabelProvider create(String id, @CheckForNull String name) {
        DescriptorExtensionList extensions = this.jenkins.getDescriptorsFor(Tool.class);
        for (Tool.ToolDescriptor descriptor : extensions) {
            if (!descriptor.getId().equals(id)) continue;
            return this.createNamedLabelProvider(descriptor.getLabelProvider(), name);
        }
        List factories = this.jenkins.getExtensionsFor(StaticAnalysisToolFactory.class);
        for (StaticAnalysisToolFactory factory : factories) {
            Optional<StaticAnalysisLabelProvider> labelProvider = factory.getLabelProvider(id);
            if (!labelProvider.isPresent()) continue;
            return this.createNamedLabelProvider(labelProvider.get(), name);
        }
        return new StaticAnalysisLabelProvider(id, name);
    }

    private StaticAnalysisLabelProvider createNamedLabelProvider(StaticAnalysisLabelProvider labelProvider, String name) {
        labelProvider.setName(name);
        return labelProvider;
    }

    @FunctionalInterface
    public static interface StaticAnalysisToolFactory
    extends ExtensionPoint {
        public Optional<StaticAnalysisLabelProvider> getLabelProvider(String var1);
    }
}

