/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import hudson.model.Api;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.charts.HealthTrendChart;
import io.jenkins.plugins.analysis.core.charts.ModifiedCodePieChart;
import io.jenkins.plugins.analysis.core.charts.NewVersusFixedPieChart;
import io.jenkins.plugins.analysis.core.charts.NewVersusFixedTrendChart;
import io.jenkins.plugins.analysis.core.charts.SeverityPieChart;
import io.jenkins.plugins.analysis.core.charts.SeverityTrendChart;
import io.jenkins.plugins.analysis.core.charts.ToolsTrendChart;
import io.jenkins.plugins.analysis.core.charts.TrendChart;
import io.jenkins.plugins.analysis.core.model.AnalysisHistory;
import io.jenkins.plugins.analysis.core.model.AnalysisResult;
import io.jenkins.plugins.analysis.core.model.BlamesModel;
import io.jenkins.plugins.analysis.core.model.ByIdResultSelector;
import io.jenkins.plugins.analysis.core.model.DetailFactory;
import io.jenkins.plugins.analysis.core.model.FileNameRenderer;
import io.jenkins.plugins.analysis.core.model.ForensicsModel;
import io.jenkins.plugins.analysis.core.model.LabelProviderFactory;
import io.jenkins.plugins.analysis.core.model.PropertyStatistics;
import io.jenkins.plugins.analysis.core.model.ResetQualityGateCommand;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.model.TabLabelProvider;
import io.jenkins.plugins.analysis.core.restapi.AnalysisResultApi;
import io.jenkins.plugins.analysis.core.restapi.ReportApi;
import io.jenkins.plugins.analysis.core.util.AffectedFilesResolver;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import io.jenkins.plugins.analysis.core.util.BuildResultNavigator;
import io.jenkins.plugins.analysis.core.util.ConsoleLogHandler;
import io.jenkins.plugins.analysis.core.util.HealthDescriptor;
import io.jenkins.plugins.analysis.core.util.LocalizedSeverity;
import io.jenkins.plugins.datatables.DefaultAsyncTableContentProvider;
import io.jenkins.plugins.datatables.TableModel;
import io.jenkins.plugins.forensics.util.CommitDecoratorFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class IssuesDetail
extends DefaultAsyncTableContentProvider
implements ModelObject {
    private static final ResetQualityGateCommand RESET_QUALITY_GATE_COMMAND = new ResetQualityGateCommand();
    private static final JacksonFacade JACKSON_FACADE = new JacksonFacade();
    private static final String ISSUES_TABLE_ID = "issues";
    private static final String BLAMES_TABLE_ID = "blames";
    private static final String FORENSICS_TABLE_ID = "forensics";
    private static final String FILE_NAME_PROPERTY = "fileName";
    private static final String ORIGIN_PROPERTY = "origin";
    private final Run<?, ?> owner;
    private final Report report;
    private final Report newIssues;
    private final Report outstandingIssues;
    private final Report fixedIssues;
    private final Charset sourceEncoding;
    private final String displayName;
    private final String url;
    private final StaticAnalysisLabelProvider labelProvider;
    private final List<String> errorMessages = new ArrayList<String>();
    private final List<String> infoMessages = new ArrayList<String>();
    private final AnalysisResult result;
    private final HealthDescriptor healthDescriptor;

    public IssuesDetail(Run<?, ?> owner, AnalysisResult result, Report report, Report newIssues, Report outstandingIssues, Report fixedIssues, String displayName, String url, StaticAnalysisLabelProvider labelProvider, Charset sourceEncoding) {
        this(owner, result, report, newIssues, outstandingIssues, fixedIssues, displayName, url, labelProvider, sourceEncoding, new HealthDescriptor(0, 0, Severity.ERROR));
    }

    public IssuesDetail(Run<?, ?> owner, AnalysisResult result, Report report, Report newIssues, Report outstandingIssues, Report fixedIssues, String displayName, String url, StaticAnalysisLabelProvider labelProvider, Charset sourceEncoding, HealthDescriptor healthDescriptor) {
        this.owner = owner;
        this.result = result;
        this.report = report;
        this.fixedIssues = fixedIssues;
        this.newIssues = newIssues;
        this.outstandingIssues = outstandingIssues;
        this.sourceEncoding = sourceEncoding;
        this.displayName = displayName;
        this.labelProvider = labelProvider;
        this.url = url;
        this.healthDescriptor = healthDescriptor;
    }

    public IssuesDetail(Run<?, ?> owner, AnalysisResult result, StaticAnalysisLabelProvider labelProvider, HealthDescriptor healthDescriptor, Charset sourceEncoding) {
        this(owner, result, result.getIssues(), result.getNewIssues(), result.getOutstandingIssues(), result.getFixedIssues(), labelProvider.getLinkName(), labelProvider.getId(), labelProvider, sourceEncoding, healthDescriptor);
        this.infoMessages.addAll(result.getInfoMessages().castToList());
        this.errorMessages.addAll(result.getErrorMessages().castToList());
    }

    AnalysisResult getResult() {
        return this.result;
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Collection<String> getInfoMessages() {
        return this.infoMessages;
    }

    public Api getApi() {
        if (this.getUrl().endsWith(this.labelProvider.getId())) {
            return new Api((Object)new AnalysisResultApi(this.result));
        }
        return new Api((Object)new ReportApi(this.getIssues(), this.result.getBlames()));
    }

    public StaticAnalysisLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public TableModel getTableModel(String id) {
        if (ISSUES_TABLE_ID.equals(id)) {
            return this.labelProvider.getIssuesModel(this.owner, this.getUrl(), this.report);
        }
        if (BLAMES_TABLE_ID.equals(id)) {
            return new BlamesModel(this.report, this.result.getBlames(), this.labelProvider.getFileNameRenderer(this.owner), this.labelProvider.getAgeBuilder(this.owner, this.getUrl()), this.labelProvider, CommitDecoratorFactory.findCommitDecorator(this.owner));
        }
        if (FORENSICS_TABLE_ID.equals(id)) {
            return new ForensicsModel(this.report, this.result.getForensics(), this.labelProvider.getFileNameRenderer(this.owner), this.labelProvider.getAgeBuilder(this.owner, this.getUrl()), this.labelProvider);
        }
        throw new NoSuchElementException("No such table model: " + id);
    }

    @JavaScriptMethod
    public String resetReference() {
        RESET_QUALITY_GATE_COMMAND.execute(this.owner, this.labelProvider.getId());
        return "{}";
    }

    @JavaScriptMethod
    public String getUrlForBuild(String build, String detailsUrl) {
        AnalysisHistory history = this.createHistory();
        for (BuildResult<AnalysisBuildResult> buildResult : history) {
            if (!buildResult.getBuild().getDisplayName().equals(build)) continue;
            return new BuildResultNavigator().getSameUrlForOtherBuild(this.owner, detailsUrl, this.getResult().getId(), buildResult.getBuild().getNumber()).orElse("");
        }
        return "";
    }

    @JavaScriptMethod
    public String getSeverityModel() {
        return JACKSON_FACADE.toJson((Object)new SeverityPieChart().create(this.report));
    }

    @JavaScriptMethod
    public String getTrendModel() {
        return JACKSON_FACADE.toJson((Object)new NewVersusFixedPieChart().create(this.newIssues, this.outstandingIssues, this.fixedIssues));
    }

    @JavaScriptMethod
    public String getModifiedModel() {
        return JACKSON_FACADE.toJson((Object)new ModifiedCodePieChart().create(this.report));
    }

    @JavaScriptMethod
    public String getBuildTrend(String configuration) {
        return this.createTrendAsJson(new SeverityTrendChart(), configuration);
    }

    @JavaScriptMethod
    public String getToolsTrend(String configuration) {
        return this.createTrendAsJson(new ToolsTrendChart(), configuration);
    }

    @JavaScriptMethod
    public String getNewVersusFixedTrend(String configuration) {
        return this.createTrendAsJson(new NewVersusFixedTrendChart(), configuration);
    }

    @JavaScriptMethod
    public String getHealthTrend(String configuration) {
        return this.createTrendAsJson(new HealthTrendChart(this.healthDescriptor), configuration);
    }

    public boolean isHealthReportEnabled() {
        return this.healthDescriptor.isEnabled();
    }

    private String createTrendAsJson(TrendChart trendChart, String configuration) {
        AnalysisHistory history = this.createHistory();
        return new JacksonFacade().toJson((Object)trendChart.create(history, ChartModelConfiguration.fromJson((String)configuration)));
    }

    private AnalysisHistory createHistory() {
        return new AnalysisHistory(this.owner, new ByIdResultSelector(this.result.getId()));
    }

    public boolean hasIssuesInModifiedCode() {
        return this.result.getTotals().getTotalModifiedSize() > 0;
    }

    public Report getIssues() {
        return this.report;
    }

    public Report getNewIssues() {
        return this.newIssues;
    }

    public Report getFixedIssues() {
        return this.fixedIssues;
    }

    public Report getOutstandingIssues() {
        return this.outstandingIssues;
    }

    public boolean isBlameVisible() {
        return !this.result.getBlames().isEmpty();
    }

    public boolean isForensicsVisible() {
        return !this.result.getForensics().isEmpty();
    }

    public boolean canDisplayFile(Issue issue) {
        return ConsoleLogHandler.isInConsoleLog(issue.getFileName()) || AffectedFilesResolver.hasAffectedFile(this.owner, issue) || new File(issue.getAbsolutePath()).exists();
    }

    public String getFileDisplayName(Issue issue) {
        return new FileNameRenderer(this.owner).getFileName(issue);
    }

    public TabLabelProvider getTabLabelProvider() {
        return new TabLabelProvider(this.getIssues());
    }

    public String getLocalizedSeverity(Severity severity) {
        return LocalizedSeverity.getLocalizedString(severity);
    }

    public PropertyStatistics getDetails(String propertyName) {
        Function<String, String> propertyFormatter = FILE_NAME_PROPERTY.equals(propertyName) ? new BaseNameMapper() : (ORIGIN_PROPERTY.equals(propertyName) ? origin -> new LabelProviderFactory().create((String)origin, this.getIssues().getNameOfOrigin(origin)).getName() : Function.identity());
        return new PropertyStatistics(this.report, this.newIssues, propertyName, propertyFormatter);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Object getDynamic(String link, StaplerRequest2 request, StaplerResponse2 response) {
        try {
            return new DetailFactory().createTrendDetails(link, this.owner, this.result, this.report, this.newIssues, this.outstandingIssues, this.fixedIssues, this.sourceEncoding, this);
        }
        catch (NoSuchElementException ignored) {
            try {
                response.sendRedirect2("../");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }
    }

    public final Run<?, ?> getOwner() {
        return this.owner;
    }

    public final boolean isCurrent() {
        return this.owner.getParent().getLastBuild().number == this.owner.number;
    }

    public String getUrl() {
        return this.url;
    }

    private static class BaseNameMapper
    implements Function<String, String> {
        private BaseNameMapper() {
        }

        @Override
        public String apply(String absolutePath) {
            try {
                Path baseName = Path.of(absolutePath, new String[0]).getFileName();
                if (baseName == null) {
                    return absolutePath;
                }
                return baseName.toString();
            }
            catch (InvalidPathException e) {
                return absolutePath;
            }
        }
    }
}

