/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Run;
import io.jenkins.plugins.analysis.core.model.AggregatedTrendAction;
import io.jenkins.plugins.analysis.core.model.Messages;
import io.jenkins.plugins.analysis.core.model.ResultAction;
import io.jenkins.plugins.analysis.core.restapi.AggregationApi;
import io.jenkins.plugins.analysis.core.restapi.ToolApi;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;

@SuppressFBWarnings(value={"UWF"}, justification="transient field owner ist restored using a Jenkins callback")
public class AggregationAction
implements RunAction2,
SimpleBuildStep.LastBuildAction {
    private transient Run<?, ?> owner;

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return Messages.Aggregation_Name();
    }

    @CheckForNull
    public String getUrlName() {
        return "warnings-ng";
    }

    public Api getApi() {
        return new Api((Object)new AggregationApi(this.findActions()));
    }

    public List<ToolApi> getTools() {
        return this.findActions();
    }

    private List<ToolApi> findActions() {
        return this.owner.getActions(ResultAction.class).stream().map(this::createToolApi).collect(Collectors.toList());
    }

    public Collection<? extends Action> getProjectActions() {
        return Set.of(new AggregatedTrendAction(this.owner.getParent()));
    }

    private ToolApi createToolApi(ResultAction result) {
        return new ToolApi(result.getId(), result.getDisplayName(), result.getAbsoluteUrl(), result.getResult().getTotalSize(), result.getResult().getSizePerSeverity());
    }

    public void onAttached(Run<?, ?> r) {
        this.owner = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.owner = r;
    }
}

