/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.core.charts;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import io.jenkins.plugins.analysis.core.charts.Messages;
import io.jenkins.plugins.analysis.core.charts.NewVersusFixedSeriesBuilder;
import io.jenkins.plugins.analysis.core.charts.TrendChart;
import io.jenkins.plugins.analysis.core.util.AnalysisBuildResult;
import io.jenkins.plugins.echarts.JenkinsPalette;

public class NewVersusFixedTrendChart
implements TrendChart {
    @Override
    public LinesChartModel create(Iterable<? extends BuildResult<AnalysisBuildResult>> results, ChartModelConfiguration configuration) {
        NewVersusFixedSeriesBuilder builder = new NewVersusFixedSeriesBuilder();
        LinesDataSet dataSet = builder.createDataSet(configuration, results);
        LinesChartModel model = new LinesChartModel(dataSet);
        LineSeries newSeries = this.getSeries(dataSet, Messages.New_Warnings_Short(), JenkinsPalette.RED, "new");
        LineSeries fixedSeries = this.getSeries(dataSet, Messages.Fixed_Warnings_Short(), JenkinsPalette.GREEN, "fixed");
        model.addSeries(new LineSeries[]{newSeries, fixedSeries});
        return model;
    }

    private LineSeries getSeries(LinesDataSet dataSet, String name, JenkinsPalette color, String dataSetId) {
        LineSeries newSeries = new LineSeries(name, color.normal(), LineSeries.StackedMode.SEPARATE_LINES, LineSeries.FilledMode.FILLED);
        newSeries.addAll(dataSet.getSeries(dataSetId));
        return newSeries;
    }
}

