/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.tasks;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.analysis.core.util.LocalizedSeverity;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

class TaskScanner {
    private static final String WORD_BOUNDARY = "\\b";
    private static final Pattern INVALID = Pattern.compile("");
    private final Map<Severity, Pattern> patterns = new HashMap<Severity, Pattern>();
    private final boolean isUppercase;
    private boolean isPatternInvalid;
    private final StringBuilder errors = new StringBuilder();

    TaskScanner(@CheckForNull String highTags, @CheckForNull String normalTags, @CheckForNull String lowTags, CaseMode caseMode, MatcherMode matcherMode) {
        boolean bl = this.isUppercase = caseMode == CaseMode.IGNORE_CASE;
        if (StringUtils.isNotBlank((CharSequence)highTags)) {
            this.patterns.put(Severity.WARNING_HIGH, this.compile(highTags, caseMode, matcherMode));
        }
        if (StringUtils.isNotBlank((CharSequence)normalTags)) {
            this.patterns.put(Severity.WARNING_NORMAL, this.compile(normalTags, caseMode, matcherMode));
        }
        if (StringUtils.isNotBlank((CharSequence)lowTags)) {
            this.patterns.put(Severity.WARNING_LOW, this.compile(lowTags, caseMode, matcherMode));
        }
    }

    String getTaskTags() {
        if (this.isPatternInvalid) {
            return "Invalid patterns detected:\n" + this.getErrors();
        }
        if (this.patterns.isEmpty()) {
            return "No task tags have been defined. Configuration Error?\n";
        }
        StringBuilder builder = new StringBuilder("Using the following tasks patterns:\n");
        for (Severity severity : Severity.getPredefinedValues()) {
            if (!this.patterns.containsKey(severity)) continue;
            builder.append("-> %s: %s%n".formatted(LocalizedSeverity.getLocalizedString(severity), this.patterns.get(severity)));
        }
        return builder.toString();
    }

    boolean isInvalidPattern() {
        return this.isPatternInvalid;
    }

    public String getErrors() {
        return this.errors.toString();
    }

    private Pattern compile(String tagIdentifiers, CaseMode caseMode, MatcherMode matcherMode) {
        try {
            if (matcherMode == MatcherMode.REGEXP_MATCH) {
                return Pattern.compile(tagIdentifiers);
            }
            ArrayList<String> regexps = new ArrayList<String>();
            for (String tag : this.splitTags(tagIdentifiers)) {
                String trimmed = tag.trim();
                if (!StringUtils.isNotBlank((CharSequence)trimmed)) continue;
                StringBuilder actual = new StringBuilder();
                if (Character.isLetterOrDigit(trimmed.charAt(0))) {
                    actual.append(WORD_BOUNDARY);
                }
                actual.append(trimmed);
                if (Character.isLetterOrDigit(trimmed.charAt(trimmed.length() - 1))) {
                    actual.append(WORD_BOUNDARY);
                }
                regexps.add(actual.toString());
            }
            String regex = "^.*(" + StringUtils.join(regexps.iterator(), (String)"|") + ")(.*)$";
            if (caseMode == CaseMode.IGNORE_CASE) {
                return Pattern.compile(regex, 2);
            }
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException exception) {
            this.isPatternInvalid = true;
            this.errors.append("Specified pattern is an invalid regular expression: '%s': '%s'".formatted(tagIdentifiers, exception.getMessage()));
            return INVALID;
        }
    }

    private String[] splitTags(String tagIdentifiers) {
        if (tagIdentifiers.indexOf(44) == -1) {
            return new String[]{tagIdentifiers};
        }
        return StringUtils.split((String)tagIdentifiers, (String)",");
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    public Report scan(Path file, Charset charset) {
        Report report;
        block10: {
            Stream<String> lines = Files.lines(file, charset);
            try {
                report = this.scanTasks(lines.iterator(), new IssueBuilder().setFileName(file.toString()));
                if (lines == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UncheckedIOException exception) {
                    Report report2 = new Report();
                    Throwable cause = exception.getCause();
                    if (cause instanceof MalformedInputException || cause instanceof UnmappableCharacterException) {
                        report2.logError("Can't read source file '%s', defined encoding '%s' seems to be wrong", new Object[]{file, charset});
                    } else {
                        report2.logException(exception, "Exception while reading the source code file '%s':", new Object[]{file});
                    }
                    return report2;
                }
            }
            lines.close();
        }
        return report;
    }

    Report scanTasks(Iterator<String> lines, IssueBuilder builder) {
        Report report = new Report();
        if (this.isPatternInvalid) {
            report.logError("%s", new Object[]{this.errors.toString()});
            return report;
        }
        IgnoreSection inIgnoreSection = new IgnoreSection();
        int lineNumber = 1;
        while (lines.hasNext()) {
            String line = lines.next();
            if (!inIgnoreSection.matches(line)) {
                for (Severity severity : Severity.getPredefinedValues()) {
                    if (!this.patterns.containsKey(severity)) continue;
                    this.createTask(builder, report, lineNumber, line, severity);
                }
            }
            ++lineNumber;
        }
        return report;
    }

    private void createTask(IssueBuilder builder, Report report, int lineNumber, String line, Severity severity) {
        Matcher matcher = this.patterns.get(severity).matcher(line);
        if (matcher.matches() && matcher.groupCount() == 2) {
            String message = StringUtils.defaultString((String)matcher.group(2)).trim();
            builder.setMessage(StringUtils.removeStart((String)message, (String)":").trim());
            String tag = StringUtils.defaultString((String)matcher.group(1));
            if (this.isUppercase) {
                builder.setType(StringUtils.upperCase((String)tag));
            } else {
                builder.setType(tag);
            }
            report.add(builder.setSeverity(severity).setLineStart(lineNumber).build());
        }
    }

    public static enum CaseMode {
        IGNORE_CASE,
        CASE_SENSITIVE;

    }

    public static enum MatcherMode {
        STRING_MATCH,
        REGEXP_MATCH;

    }

    private static class IgnoreSection {
        private static final String IGNORE_BEGIN = " task-scanner-ignore-begin";
        private static final String IGNORE_END = " task-scanner-ignore-end";
        private boolean ignore;

        private IgnoreSection() {
        }

        public boolean matches(String line) {
            if (line.contains(IGNORE_BEGIN)) {
                this.ignore = true;
            } else if (line.contains(IGNORE_END)) {
                this.ignore = false;
            }
            return this.ignore;
        }
    }
}

