/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.tasks;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.Report;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.analysis.core.util.FileFinder;
import io.jenkins.plugins.analysis.warnings.tasks.TaskScanner;
import io.jenkins.plugins.analysis.warnings.tasks.TaskScannerBuilder;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;

class AgentScanner
extends MasterToSlaveFileCallable<Report> {
    private static final long serialVersionUID = -4417487030800559491L;
    private final String highTasks;
    private final String normalTasks;
    private final String lowTasks;
    private final TaskScanner.CaseMode caseMode;
    private final TaskScanner.MatcherMode matcherMode;
    private final String includePattern;
    private final String excludePattern;
    private final String sourceCodeEncoding;

    AgentScanner(String highTasks, String normalTasks, String lowTasks, TaskScanner.CaseMode caseMode, TaskScanner.MatcherMode matcherMode, String includePattern, String excludePattern, String sourceCodeEncoding) {
        this.highTasks = highTasks;
        this.normalTasks = normalTasks;
        this.lowTasks = lowTasks;
        this.caseMode = caseMode;
        this.matcherMode = matcherMode;
        this.includePattern = StringUtils.defaultString((String)includePattern);
        this.excludePattern = StringUtils.defaultString((String)excludePattern);
        this.sourceCodeEncoding = sourceCodeEncoding;
    }

    public Report invoke(File workspace, VirtualChannel channel) {
        Report report = new Report();
        report.logInfo("Searching for files in workspace '%s' that match the include pattern '%s' and exclude pattern '%s'", new Object[]{workspace, this.includePattern, this.excludePattern});
        FileFinder fileFinder = new FileFinder(this.includePattern, this.excludePattern);
        String[] fileNames = fileFinder.find(workspace);
        report.logInfo("-> found %d files that will be scanned", new Object[]{fileNames.length});
        Path root = workspace.toPath();
        TaskScanner scanner = this.createTaskScanner();
        report.logInfo(scanner.getTaskTags(), new Object[0]);
        report.logInfo("Scanning all %d files for open tasks", new Object[]{fileNames.length});
        for (String fileName : fileNames) {
            report.addAll(scanner.scan(root.resolve(fileName), this.getCharset()).get());
            if (!Thread.interrupted()) continue;
            throw new ParsingCanceledException();
        }
        report.logInfo("Found a total of %d open tasks", new Object[]{report.size()});
        Map countPerType = report.getPropertyCount(Issue::getType);
        for (Map.Entry entry : countPerType.entrySet()) {
            report.logInfo("-> %s: %d open tasks", new Object[]{entry.getKey(), entry.getValue()});
        }
        return report;
    }

    private Charset getCharset() {
        return new ValidationUtilities().getCharset(this.sourceCodeEncoding);
    }

    private TaskScanner createTaskScanner() {
        TaskScannerBuilder builder = new TaskScannerBuilder();
        builder.setHighTasks(this.highTasks).setNormalTasks(this.normalTasks).setLowTasks(this.lowTasks).setMatcherMode(this.matcherMode).setCaseMode(this.caseMode);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AgentScanner that = (AgentScanner)((Object)o);
        if (this.highTasks != null ? !this.highTasks.equals(that.highTasks) : that.highTasks != null) {
            return false;
        }
        if (this.normalTasks != null ? !this.normalTasks.equals(that.normalTasks) : that.normalTasks != null) {
            return false;
        }
        if (this.lowTasks != null ? !this.lowTasks.equals(that.lowTasks) : that.lowTasks != null) {
            return false;
        }
        if (this.caseMode != that.caseMode) {
            return false;
        }
        if (this.matcherMode != that.matcherMode) {
            return false;
        }
        if (this.includePattern != null ? !this.includePattern.equals(that.includePattern) : that.includePattern != null) {
            return false;
        }
        if (this.excludePattern != null ? !this.excludePattern.equals(that.excludePattern) : that.excludePattern != null) {
            return false;
        }
        return this.sourceCodeEncoding != null ? this.sourceCodeEncoding.equals(that.sourceCodeEncoding) : that.sourceCodeEncoding == null;
    }

    public int hashCode() {
        int result = this.highTasks != null ? this.highTasks.hashCode() : 0;
        result = 31 * result + (this.normalTasks != null ? this.normalTasks.hashCode() : 0);
        result = 31 * result + (this.lowTasks != null ? this.lowTasks.hashCode() : 0);
        result = 31 * result + (this.caseMode != null ? this.caseMode.hashCode() : 0);
        result = 31 * result + (this.matcherMode != null ? this.matcherMode.hashCode() : 0);
        result = 31 * result + (this.includePattern != null ? this.includePattern.hashCode() : 0);
        result = 31 * result + (this.excludePattern != null ? this.excludePattern.hashCode() : 0);
        result = 31 * result + (this.sourceCodeEncoding != null ? this.sourceCodeEncoding.hashCode() : 0);
        return result;
    }
}

