/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.groovy;

import edu.hm.hafner.util.VisibleForTesting;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.analysis.core.model.LabelProviderFactory;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.warnings.groovy.GroovyParser;
import io.jenkins.plugins.analysis.warnings.groovy.Messages;
import io.jenkins.plugins.util.GlobalConfigurationFacade;
import io.jenkins.plugins.util.GlobalConfigurationItem;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@Extension
@Symbol(value={"warningsParsers"})
public class ParserConfiguration
extends GlobalConfigurationItem {
    private List<GroovyParser> parsers = new ArrayList<GroovyParser>();
    private boolean consoleLogScanningPermitted;

    public ParserConfiguration() {
        this.load();
    }

    @VisibleForTesting
    ParserConfiguration(GlobalConfigurationFacade facade) {
        super(facade);
        this.load();
    }

    public static ParserConfiguration getInstance() {
        return (ParserConfiguration)((Object)ParserConfiguration.all().get(ParserConfiguration.class));
    }

    protected void clearRepeatableProperties() {
        this.setParsers(new ArrayList<GroovyParser>());
    }

    public List<GroovyParser> getParsers() {
        return this.parsers;
    }

    @DataBoundSetter
    public void setParsers(List<GroovyParser> parsers) {
        this.parsers = new ArrayList<GroovyParser>(parsers);
        this.save();
    }

    public void deleteParser(String parserId) {
        if (!this.contains(parserId)) {
            throw new NoSuchElementException("No Groovy parser with ID '%s' found.".formatted(parserId));
        }
        GroovyParser parser = this.getParser(parserId);
        this.parsers.remove(parser);
        this.save();
    }

    public void addParser(GroovyParser parser) {
        String parserId = parser.getId();
        if (this.contains(parserId)) {
            throw new IllegalArgumentException("ID '%s' already exists.".formatted(parserId));
        }
        this.parsers.add(parser);
        this.save();
    }

    public boolean isConsoleLogScanningPermitted() {
        return this.consoleLogScanningPermitted;
    }

    @DataBoundSetter
    public void setConsoleLogScanningPermitted(boolean consoleLogScanningPermitted) {
        this.consoleLogScanningPermitted = consoleLogScanningPermitted;
        this.save();
    }

    public FormValidation doCheckConsoleLogScanningPermitted(@QueryParameter boolean value) {
        if (value) {
            return FormValidation.warning((String)Messages.ParserConfiguration_consoleLogScanningPermitted());
        }
        return FormValidation.ok();
    }

    public boolean canEditParsers() {
        return new JenkinsFacade().hasPermission(Jenkins.ADMINISTER);
    }

    public GroovyParser getParser(String id) {
        for (GroovyParser parser : this.parsers) {
            if (!parser.getId().equals(id)) continue;
            return parser;
        }
        throw new NoSuchElementException("No Groovy parser with ID '%s' found.".formatted(id));
    }

    public boolean contains(String id) {
        for (GroovyParser parser : this.parsers) {
            if (!parser.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public ListBoxModel asListBoxModel() {
        ListBoxModel items = new ListBoxModel();
        for (GroovyParser parser : this.parsers) {
            items.add(parser.getName(), parser.getId());
        }
        return items;
    }

    @Extension
    public static class ParserFactory
    implements LabelProviderFactory.StaticAnalysisToolFactory {
        @Override
        public Optional<StaticAnalysisLabelProvider> getLabelProvider(String id) {
            return ParserConfiguration.getInstance().parsers.stream().filter(p -> id.equals(p.getId())).findAny().map(p -> new StaticAnalysisLabelProvider(p.getId(), p.getName()));
        }
    }
}

