/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.axivion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import io.jenkins.plugins.analysis.warnings.axivion.AxIssueKind;
import io.jenkins.plugins.analysis.warnings.axivion.AxRawIssue;
import org.apache.commons.lang3.Validate;

final class DefaultTransformations {
    private DefaultTransformations() {
        throw new InstantiationError("no instances");
    }

    static Issue createAVIssue(AxRawIssue rawIssue) {
        Validate.isTrue((boolean)rawIssue.getKind().equals((Object)AxIssueKind.AV));
        JsonObject payload = rawIssue.getPayload();
        String description = DefaultTransformations.createDescription(rawIssue, payload);
        try (IssueBuilder builder = new IssueBuilder();){
            Issue issue = builder.setPathName(rawIssue.getProjectDir()).setFileName(DefaultTransformations.getString(payload, "sourcePath")).setLineStart(DefaultTransformations.getString(payload, "sourceLine")).setType(DefaultTransformations.getString(payload, "violationType")).setCategory(rawIssue.getKind().name()).setMessage("Architecture Violation").setDescription(description).setFingerprint(rawIssue.getKind().name() + DefaultTransformations.getString(payload, "id")).setSeverity(Severity.WARNING_HIGH).build();
            return issue;
        }
    }

    private static String createDescription(AxRawIssue rawIssue, JsonObject payload) {
        if ("Divergence".equals(DefaultTransformations.getString(payload, "violationType"))) {
            return "Unexpected dependency from <i>" + DefaultTransformations.getString(payload, "architectureSourceType") + " &lt;" + DefaultTransformations.getString(payload, "architectureSource") + "&gt;</i> to <i>" + DefaultTransformations.getString(payload, "architectureTargetType") + " &lt;" + DefaultTransformations.getString(payload, "architectureTarget") + "&gt;</i><p>Cause is a <i>" + DefaultTransformations.getString(payload, "dependencyType") + "</i> dependency from <i>" + DefaultTransformations.getString(payload, "sourceEntityType") + " &lt;" + DefaultTransformations.getString(payload, "sourceEntity") + "&gt;</i> to <i>" + DefaultTransformations.getString(payload, "targetEntityType") + " &lt;" + DefaultTransformations.getString(payload, "targetEntity") + "&gt;</i>" + DefaultTransformations.createLink(rawIssue, DefaultTransformations.getInt(payload, "id"));
        }
        return "Missing Architecture Dependency from <i>" + DefaultTransformations.getString(payload, "architectureSourceType") + " &lt;" + DefaultTransformations.getString(payload, "architectureSource") + "&gt;</i> to <i>" + DefaultTransformations.getString(payload, "architectureTargetType") + " &lt;" + DefaultTransformations.getString(payload, "architectureTarget") + "&gt;</i>" + DefaultTransformations.createLink(rawIssue, DefaultTransformations.getInt(payload, "id"));
    }

    static Issue createCLIssue(AxRawIssue rawIssue) {
        Validate.isTrue((boolean)rawIssue.getKind().equals((Object)AxIssueKind.CL));
        JsonObject payload = rawIssue.getPayload();
        String cloneType = "type " + DefaultTransformations.getInt(payload, "cloneType");
        String description = "Left part of clone pair of " + cloneType + " clone of length " + DefaultTransformations.getInt(payload, "leftLength") + "LOC" + DefaultTransformations.createLink(rawIssue, DefaultTransformations.getInt(payload, "id"));
        try (IssueBuilder builder = new IssueBuilder();){
            Issue issue = builder.setPathName(rawIssue.getProjectDir()).setFileName(DefaultTransformations.getString(payload, "leftPath")).setLineStart(DefaultTransformations.getInt(payload, "leftLine")).setLineEnd(DefaultTransformations.getInt(payload, "leftEndLine")).setType(cloneType).setCategory(rawIssue.getKind().name()).setMessage(cloneType + " clone").setDescription(description).setFingerprint(rawIssue.getKindName() + DefaultTransformations.getInt(payload, "id")).setSeverity(Severity.WARNING_NORMAL).build();
            return issue;
        }
    }

    static Issue createCYIssue(AxRawIssue rawIssue) {
        JsonObject payload = rawIssue.getPayload();
        String description = "Source: " + DefaultTransformations.getString(payload, "sourceEntity") + " Target: " + DefaultTransformations.getString(payload, "targetEntity") + DefaultTransformations.createLink(rawIssue, DefaultTransformations.getInt(payload, "id"));
        try (IssueBuilder builder = new IssueBuilder();){
            Issue issue = builder.setPathName(rawIssue.getProjectDir()).setFileName(DefaultTransformations.getString(payload, "sourcePath")).setLineStart(DefaultTransformations.getInt(payload, "sourceLine")).setType("Cycle").setCategory(rawIssue.getKindName()).setMessage("Call cycle").setDescription(description).setFingerprint(rawIssue.getKindName() + DefaultTransformations.getInt(payload, "id")).setSeverity(Severity.WARNING_HIGH).build();
            return issue;
        }
    }

    static Issue createDEIssue(AxRawIssue rawIssue) {
        Validate.isTrue((boolean)rawIssue.getKind().equals((Object)AxIssueKind.DE));
        JsonObject payload = rawIssue.getPayload();
        String description = DefaultTransformations.getString(payload, "entityType") + "<i>" + DefaultTransformations.getString(payload, "entity") + "</i>" + DefaultTransformations.createLink(rawIssue, DefaultTransformations.getInt(payload, "id"));
        try (IssueBuilder builder = new IssueBuilder();){
            Issue issue = builder.setPathName(rawIssue.getProjectDir()).setFileName(DefaultTransformations.getString(payload, "path")).setLineStart(DefaultTransformations.getInt(payload, "line")).setType("Dead Entity").setCategory(rawIssue.getKindName()).setMessage("Entity is dead").setDescription(description).setFingerprint(rawIssue.getKindName() + DefaultTransformations.getInt(payload, "id")).setSeverity(Severity.WARNING_HIGH).build();
            return issue;
        }
    }

    static Issue createMVIssue(AxRawIssue rawIssue) {
        Validate.isTrue((boolean)rawIssue.getKind().equals((Object)AxIssueKind.MV));
        JsonObject payload = rawIssue.getPayload();
        String description = DefaultTransformations.getString(payload, "entityType") + " <i>" + DefaultTransformations.getString(payload, "entity") + "</i><p>Val: <b>" + DefaultTransformations.getInt(payload, "value") + "</b><br>Max: " + DefaultTransformations.getInt(payload, "max") + "<br>Min: " + DefaultTransformations.getInt(payload, "min") + DefaultTransformations.createLink(rawIssue, DefaultTransformations.getInt(payload, "id"));
        try (IssueBuilder builder = new IssueBuilder();){
            Issue issue = builder.setPathName(rawIssue.getProjectDir()).setFileName(DefaultTransformations.getString(payload, "path")).setLineStart(DefaultTransformations.getInt(payload, "line")).setType(DefaultTransformations.getString(payload, "description")).setCategory(rawIssue.getKindName()).setMessage("Metric " + DefaultTransformations.getString(payload, "description") + " out of valid range").setDescription(description).setFingerprint(rawIssue.getKindName() + DefaultTransformations.getInt(payload, "id")).setSeverity(Severity.WARNING_HIGH).build();
            return issue;
        }
    }

    static Issue createSVIssue(AxRawIssue rawIssue) {
        Validate.isTrue((boolean)rawIssue.getKind().equals((Object)AxIssueKind.SV));
        JsonObject payload = rawIssue.getPayload();
        String description = DefaultTransformations.getString(payload, "message") + " <i>" + DefaultTransformations.getString(payload, "entity") + "</i>" + DefaultTransformations.createLink(rawIssue, DefaultTransformations.getInt(payload, "id"));
        try (IssueBuilder builder = new IssueBuilder();){
            Issue issue = builder.setPathName(rawIssue.getProjectDir()).setFileName(DefaultTransformations.getString(payload, "path")).setLineStart(DefaultTransformations.getInt(payload, "line")).setType(DefaultTransformations.getString(payload, "errorNumber")).setCategory(rawIssue.getKindName()).setMessage("Style violation " + DefaultTransformations.getString(payload, "errorNumber")).setDescription(description).setFingerprint(rawIssue.getKindName() + DefaultTransformations.getInt(payload, "id")).setSeverity(DefaultTransformations.parsePriority(payload)).build();
            return issue;
        }
    }

    private static Severity parsePriority(JsonObject payload) {
        String severity = DefaultTransformations.getString(payload, "severity");
        if (severity != null) {
            if ("mandatory".equals(severity)) {
                return Severity.WARNING_HIGH;
            }
            if ("advisory".equals(severity)) {
                return Severity.WARNING_LOW;
            }
        }
        return Severity.WARNING_NORMAL;
    }

    private static String createLink(AxRawIssue issue, int id) {
        return "<p><a target=\"_blank\" rel=\"noopener noreferrer\" href=\"" + issue.getDashboardUrl() + "/issues/" + issue.getKind().name() + id + "\">More details</a>";
    }

    private static String getString(JsonObject payload, String memberName) {
        JsonElement intermediate = payload.get(memberName);
        return DefaultTransformations.isJsonNull(intermediate) ? "" : intermediate.getAsString();
    }

    private static int getInt(JsonObject payload, String memberName) {
        JsonElement intermediate = payload.get(memberName);
        return DefaultTransformations.isJsonNull(intermediate) ? -1 : intermediate.getAsInt();
    }

    private static boolean isJsonNull(JsonElement element) {
        return element == null || element.isJsonNull();
    }
}

