/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings.axivion;

import edu.hm.hafner.analysis.Issue;
import io.jenkins.plugins.analysis.warnings.axivion.AxIssueTransformation;
import io.jenkins.plugins.analysis.warnings.axivion.AxRawIssue;
import io.jenkins.plugins.analysis.warnings.axivion.DefaultTransformations;

enum AxIssueKind {
    AV("architecture violations", DefaultTransformations::createAVIssue),
    CL("clones", DefaultTransformations::createCLIssue),
    CY("cycles", DefaultTransformations::createCYIssue),
    DE("dead entities", DefaultTransformations::createDEIssue),
    MV("metric violations", DefaultTransformations::createMVIssue),
    SV("style violations", DefaultTransformations::createSVIssue);

    private final String pluralName;
    private final AxIssueTransformation transformation;

    private AxIssueKind(String pluralName, AxIssueTransformation transformation) {
        this.pluralName = pluralName;
        this.transformation = transformation;
    }

    public String plural() {
        return this.pluralName;
    }

    public Issue transform(AxRawIssue rawIssue) {
        return this.transformation.transform(rawIssue);
    }
}

