/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.analysis.warnings;

import edu.hm.hafner.analysis.DuplicationGroup;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.registry.ParserDescriptor;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Run;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import io.jenkins.plugins.analysis.core.model.AnalysisModelParser;
import io.jenkins.plugins.analysis.core.model.DescriptionProvider;
import io.jenkins.plugins.analysis.core.model.DetailsTableModel;
import io.jenkins.plugins.analysis.core.model.FileNameRenderer;
import io.jenkins.plugins.analysis.core.model.StaticAnalysisLabelProvider;
import io.jenkins.plugins.analysis.core.model.SymbolIconLabelProvider;
import io.jenkins.plugins.analysis.warnings.Messages;
import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.prism.Sanitizer;
import io.jenkins.plugins.util.JenkinsFacade;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class DuplicateCodeScanner
extends AnalysisModelParser {
    private static final long serialVersionUID = -8446643146836067375L;
    private static final ThresholdValidation THRESHOLD_VALIDATION = new ThresholdValidation();
    private int highThreshold = 50;
    private int normalThreshold = 25;

    @Override
    protected ParserDescriptor.Option[] configureOptions() {
        return new ParserDescriptor.Option[]{new ParserDescriptor.Option("DRY-HIGH-THRESHOLD", String.valueOf(this.getHighThreshold())), new ParserDescriptor.Option("DRY-NORMAL-THRESHOLD", String.valueOf(this.getNormalThreshold()))};
    }

    public int getHighThreshold() {
        return THRESHOLD_VALIDATION.getHighThreshold(this.normalThreshold, this.highThreshold);
    }

    @DataBoundSetter
    public void setHighThreshold(int highThreshold) {
        this.highThreshold = highThreshold;
    }

    public int getNormalThreshold() {
        return THRESHOLD_VALIDATION.getNormalThreshold(this.normalThreshold, this.highThreshold);
    }

    @DataBoundSetter
    public void setNormalThreshold(int normalThreshold) {
        this.normalThreshold = normalThreshold;
    }

    static class ThresholdValidation {
        static final int DEFAULT_HIGH_THRESHOLD = 50;
        static final int DEFAULT_NORMAL_THRESHOLD = 25;

        ThresholdValidation() {
        }

        public FormValidation validateHigh(int highThreshold, int normalThreshold) {
            return this.validate(highThreshold, normalThreshold, Messages.DRY_ValidationError_HighThreshold());
        }

        public FormValidation validateNormal(int highThreshold, int normalThreshold) {
            return this.validate(highThreshold, normalThreshold, Messages.DRY_ValidationError_NormalThreshold());
        }

        private FormValidation validate(int high, int normal, String message) {
            if (this.isValid(normal, high)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)message);
        }

        public int getHighThreshold(int normalThreshold, int highThreshold) {
            if (!this.isValid(normalThreshold, highThreshold)) {
                return 50;
            }
            return highThreshold;
        }

        private boolean isValid(int normalThreshold, int highThreshold) {
            return highThreshold > 0 && normalThreshold > 0 && highThreshold > normalThreshold;
        }

        public int getNormalThreshold(int normalThreshold, int highThreshold) {
            if (!this.isValid(normalThreshold, highThreshold)) {
                return 25;
            }
            return normalThreshold;
        }
    }

    public static class DryModel
    extends DetailsTableModel {
        DryModel(Report report, FileNameRenderer fileNameRenderer, StaticAnalysisLabelProvider.AgeBuilder ageBuilder, DescriptionProvider descriptionProvider) {
            super(report, fileNameRenderer, ageBuilder, descriptionProvider, new JenkinsFacade());
        }

        @VisibleForTesting
        DryModel(Report report, FileNameRenderer fileNameRenderer, StaticAnalysisLabelProvider.AgeBuilder ageBuilder, DescriptionProvider descriptionProvider, JenkinsFacade jenkinsFacade) {
            super(report, fileNameRenderer, ageBuilder, descriptionProvider, jenkinsFacade);
        }

        public String getId() {
            return "issues";
        }

        public List<TableColumn> getColumns() {
            ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
            columns.add(this.createDetailsColumn());
            columns.add(this.createFileColumn());
            if (this.getReport().hasPackages()) {
                columns.add(this.createPackageColumn());
            }
            TableColumn severity = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.DRY_Table_Column_Severity()).withDataPropertyKey("severity").withResponsivePriority(100).build();
            columns.add(severity);
            TableColumn linesCount = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.DRY_Table_Column_LinesCount()).withDataPropertyKey("linesCount").withResponsivePriority(5).withHeaderClass(TableColumn.ColumnCss.NUMBER).build();
            columns.add(linesCount);
            TableColumn duplicatedIn = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.DRY_Table_Column_DuplicatedIn()).withDataPropertyKey("duplicatedIn").withResponsivePriority(50).build();
            columns.add(duplicatedIn);
            columns.add(this.createAgeColumn());
            return columns;
        }

        @Override
        public DuplicationRow getRow(Issue issue) {
            DuplicationRow row = new DuplicationRow(this.getAgeBuilder(), this.getFileNameRenderer(), this.getDescriptionProvider(), issue, this.getJenkinsFacade());
            row.setPackageName(issue);
            row.setSeverity(issue);
            row.setLinesCount(String.valueOf(issue.getLineEnd() - issue.getLineStart() + 1));
            row.setDuplicatedIn(DryLabelProvider.formatTargets(this.getFileNameRenderer(), issue));
            return row;
        }

        public static class DuplicationRow
        extends DetailsTableModel.TableRow {
            private String packageName;
            private String severity;
            private String linesCount;
            private String duplicatedIn;

            DuplicationRow(StaticAnalysisLabelProvider.AgeBuilder ageBuilder, FileNameRenderer fileNameRenderer, DescriptionProvider descriptionProvider, Issue issue, JenkinsFacade jenkinsFacade) {
                super(ageBuilder, fileNameRenderer, descriptionProvider, issue, jenkinsFacade);
            }

            public String getPackageName() {
                return this.packageName;
            }

            public String getSeverity() {
                return this.severity;
            }

            public String getLinesCount() {
                return this.linesCount;
            }

            public String getDuplicatedIn() {
                return this.duplicatedIn;
            }

            void setPackageName(Issue issue) {
                this.packageName = this.formatProperty("packageName", issue.getPackageName());
            }

            void setLinesCount(String linesCount) {
                this.linesCount = linesCount;
            }

            void setDuplicatedIn(String duplicatedIn) {
                this.duplicatedIn = duplicatedIn;
            }

            void setSeverity(Issue issue) {
                this.severity = this.formatSeverity(issue.getSeverity());
            }
        }
    }

    static abstract class DuplicateCodeDescriptor
    extends AnalysisModelParser.AnalysisModelParserDescriptor {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();
        private static final ThresholdValidation VALIDATION = new ThresholdValidation();

        DuplicateCodeDescriptor(String id) {
            super(id);
        }

        @POST
        public FormValidation doCheckHighThreshold(@AncestorInPath BuildableItem project, @QueryParameter(value="highThreshold") int highThreshold, @QueryParameter(value="normalThreshold") int normalThreshold) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION.validateHigh(highThreshold, normalThreshold);
        }

        @POST
        public FormValidation doCheckNormalThreshold(@AncestorInPath BuildableItem project, @QueryParameter(value="highThreshold") int highThreshold, @QueryParameter(value="normalThreshold") int normalThreshold) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION.validateNormal(highThreshold, normalThreshold);
        }
    }

    static class DryLabelProvider
    extends SymbolIconLabelProvider {
        private static final Sanitizer SANITIZER = new Sanitizer();

        protected DryLabelProvider(String id, String name) {
            super(id, name, EMPTY_DESCRIPTION, "symbol-regular/clone plugin-font-awesome-api");
        }

        @Override
        public String getDescription(Issue issue) {
            Serializable properties = issue.getAdditionalProperties();
            if (properties instanceof DuplicationGroup) {
                DuplicationGroup group = (DuplicationGroup)properties;
                return TagCreator.pre().with((DomContent)new UnescapedText(this.getCodeFragment(group))).renderFormatted();
            }
            return super.getDescription(issue);
        }

        private String getCodeFragment(DuplicationGroup duplicationGroup) {
            return SANITIZER.render((DomContent)TagCreator.code((String)duplicationGroup.getCodeFragment()));
        }

        @Override
        public String getSourceCodeDescription(Run<?, ?> build, Issue issue) {
            return DryLabelProvider.formatTargets(this.getFileNameRenderer(build), issue, "../");
        }

        @Override
        public DetailsTableModel getIssuesModel(Run<?, ?> build, String url, Report report) {
            return new DryModel(report, this.getFileNameRenderer(build), this.getAgeBuilder(build, url), this);
        }

        static String formatTargets(FileNameRenderer fileNameRenderer, Issue issue) {
            return DryLabelProvider.formatTargets(fileNameRenderer, issue, "");
        }

        static String formatTargets(FileNameRenderer fileNameRenderer, Issue issue, String prefix) {
            Serializable properties = issue.getAdditionalProperties();
            if (properties instanceof DuplicationGroup) {
                DuplicationGroup group = (DuplicationGroup)properties;
                List duplications = group.getDuplications();
                duplications.remove(issue);
                return TagCreator.ul((DomContent[])new DomContent[]{TagCreator.each((Collection)duplications, link -> TagCreator.li((DomContent[])new DomContent[]{fileNameRenderer.createAffectedFileLink((Issue)link, prefix)}))}).render();
            }
            return "-";
        }

        @Override
        public String getTrendName() {
            return Messages.DRY_Trend_Name(this.getName());
        }

        @Override
        public String getLinkName() {
            return Messages.DRY_Link_Name(this.getName());
        }
    }
}

